// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.MetricsAdvisor.Models
{
    /// <summary>
    /// incident status
    ///
    /// only return for alerting incident result
    /// </summary>
    public readonly partial struct AnomalyIncidentStatus : IEquatable<AnomalyIncidentStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AnomalyIncidentStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AnomalyIncidentStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "Active";
        private const string ResolvedValue = "Resolved";
        /// <summary> Determines if two <see cref="AnomalyIncidentStatus"/> values are the same. </summary>
        public static bool operator ==(AnomalyIncidentStatus left, AnomalyIncidentStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AnomalyIncidentStatus"/> values are not the same. </summary>
        public static bool operator !=(AnomalyIncidentStatus left, AnomalyIncidentStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AnomalyIncidentStatus"/>. </summary>
        public static implicit operator AnomalyIncidentStatus(string value) => new AnomalyIncidentStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AnomalyIncidentStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AnomalyIncidentStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
