// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;

namespace Azure.AI.MetricsAdvisor.Models
{
    public partial class AnomalyIncident
    {
        internal static AnomalyIncident DeserializeAnomalyIncident(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string dataFeedId = default;
            string metricId = default;
            string anomalyDetectionConfigurationId = default;
            string incidentId = default;
            DateTimeOffset startTime = default;
            DateTimeOffset lastTime = default;
            SeriesIdentity rootNode = default;
            IncidentProperty property = default;
            foreach (var property0 in element.EnumerateObject())
            {
                if (property0.NameEquals("dataFeedId"u8))
                {
                    dataFeedId = property0.Value.GetString();
                    continue;
                }
                if (property0.NameEquals("metricId"u8))
                {
                    metricId = property0.Value.GetString();
                    continue;
                }
                if (property0.NameEquals("anomalyDetectionConfigurationId"u8))
                {
                    anomalyDetectionConfigurationId = property0.Value.GetString();
                    continue;
                }
                if (property0.NameEquals("incidentId"u8))
                {
                    incidentId = property0.Value.GetString();
                    continue;
                }
                if (property0.NameEquals("startTime"u8))
                {
                    startTime = property0.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property0.NameEquals("lastTime"u8))
                {
                    lastTime = property0.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property0.NameEquals("rootNode"u8))
                {
                    rootNode = SeriesIdentity.DeserializeSeriesIdentity(property0.Value);
                    continue;
                }
                if (property0.NameEquals("property"u8))
                {
                    property = IncidentProperty.DeserializeIncidentProperty(property0.Value);
                    continue;
                }
            }
            return new AnomalyIncident(
                dataFeedId,
                metricId,
                anomalyDetectionConfigurationId,
                incidentId,
                startTime,
                lastTime,
                rootNode,
                property);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AnomalyIncident FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAnomalyIncident(document.RootElement);
        }
    }
}
