// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;

namespace Azure.AI.MetricsAdvisor.Models
{
    internal partial class AnomalyFeedbackValue : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            writer.WritePropertyName("anomalyValue"u8);
            writer.WriteStringValue(AnomalyValue.ToString());
            writer.WriteEndObject();
        }

        internal static AnomalyFeedbackValue DeserializeAnomalyFeedbackValue(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            AnomalyValue anomalyValue = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("anomalyValue"u8))
                {
                    anomalyValue = new AnomalyValue(property.Value.GetString());
                    continue;
                }
            }
            return new AnomalyFeedbackValue(anomalyValue);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AnomalyFeedbackValue FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAnomalyFeedbackValue(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
