// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.AI.MetricsAdvisor.Models
{
    /// <summary> The AnomalyDimensionList. </summary>
    internal partial class AnomalyDimensionList
    {
        /// <summary> Initializes a new instance of <see cref="AnomalyDimensionList"/>. </summary>
        /// <param name="value"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        internal AnomalyDimensionList(IEnumerable<string> value)
        {
            Argument.AssertNotNull(value, nameof(value));

            Value = value.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="AnomalyDimensionList"/>. </summary>
        /// <param name="nextLink"></param>
        /// <param name="value"></param>
        internal AnomalyDimensionList(string nextLink, IReadOnlyList<string> value)
        {
            NextLink = nextLink;
            Value = value;
        }

        /// <summary> Gets the next link. </summary>
        public string NextLink { get; }
        /// <summary> Gets the value. </summary>
        public IReadOnlyList<string> Value { get; }
    }
}
