// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.MetricsAdvisor.Models
{
    /// <summary> detection direction. </summary>
    public readonly partial struct AnomalyDetectorDirection : IEquatable<AnomalyDetectorDirection>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AnomalyDetectorDirection"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AnomalyDetectorDirection(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BothValue = "Both";
        private const string DownValue = "Down";
        private const string UpValue = "Up";
        /// <summary> Determines if two <see cref="AnomalyDetectorDirection"/> values are the same. </summary>
        public static bool operator ==(AnomalyDetectorDirection left, AnomalyDetectorDirection right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AnomalyDetectorDirection"/> values are not the same. </summary>
        public static bool operator !=(AnomalyDetectorDirection left, AnomalyDetectorDirection right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AnomalyDetectorDirection"/>. </summary>
        public static implicit operator AnomalyDetectorDirection(string value) => new AnomalyDetectorDirection(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AnomalyDetectorDirection other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AnomalyDetectorDirection other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
