// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.AI.MetricsAdvisor.Models
{
    /// <summary> The AnomalyDetectionConfigurationPatch. </summary>
    internal partial class AnomalyDetectionConfigurationPatch
    {
        /// <summary> Initializes a new instance of <see cref="AnomalyDetectionConfigurationPatch"/>. </summary>
        public AnomalyDetectionConfigurationPatch()
        {
            DimensionGroupOverrideConfigurations = new ChangeTrackingList<MetricSeriesGroupDetectionCondition>();
            SeriesOverrideConfigurations = new ChangeTrackingList<MetricSingleSeriesDetectionCondition>();
        }

        /// <summary> Initializes a new instance of <see cref="AnomalyDetectionConfigurationPatch"/>. </summary>
        /// <param name="name"> anomaly detection configuration name. </param>
        /// <param name="description"> anomaly detection configuration description. </param>
        /// <param name="wholeMetricConfiguration"></param>
        /// <param name="dimensionGroupOverrideConfigurations"> detection configuration for series group. </param>
        /// <param name="seriesOverrideConfigurations"> detection configuration for specific series. </param>
        internal AnomalyDetectionConfigurationPatch(string name, string description, WholeMetricConfigurationPatch wholeMetricConfiguration, IList<MetricSeriesGroupDetectionCondition> dimensionGroupOverrideConfigurations, IList<MetricSingleSeriesDetectionCondition> seriesOverrideConfigurations)
        {
            Name = name;
            Description = description;
            WholeMetricConfiguration = wholeMetricConfiguration;
            DimensionGroupOverrideConfigurations = dimensionGroupOverrideConfigurations;
            SeriesOverrideConfigurations = seriesOverrideConfigurations;
        }

        /// <summary> anomaly detection configuration name. </summary>
        public string Name { get; set; }
        /// <summary> anomaly detection configuration description. </summary>
        public string Description { get; set; }
        /// <summary> Gets or sets the whole metric configuration. </summary>
        public WholeMetricConfigurationPatch WholeMetricConfiguration { get; set; }
    }
}
