// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.AI.MetricsAdvisor.Models
{
    public partial class AnomalyAlertConfiguration : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            writer.WritePropertyName("name"u8);
            writer.WriteStringValue(Name);
            if (Optional.IsDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStringValue(Description);
            }
            if (Optional.IsDefined(CrossMetricsOperator))
            {
                writer.WritePropertyName("crossMetricsOperator"u8);
                writer.WriteStringValue(CrossMetricsOperator.Value.ToString());
            }
            if (Optional.IsCollectionDefined(DimensionsToSplitAlert))
            {
                writer.WritePropertyName("splitAlertByDimensions"u8);
                writer.WriteStartArray();
                foreach (var item in DimensionsToSplitAlert)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            writer.WritePropertyName("hookIds"u8);
            writer.WriteStartArray();
            foreach (var item in IdsOfHooksToAlert)
            {
                writer.WriteStringValue(item);
            }
            writer.WriteEndArray();
            writer.WritePropertyName("metricAlertingConfigurations"u8);
            writer.WriteStartArray();
            foreach (var item in MetricAlertConfigurations)
            {
                writer.WriteObjectValue<MetricAlertConfiguration>(item);
            }
            writer.WriteEndArray();
            writer.WriteEndObject();
        }

        internal static AnomalyAlertConfiguration DeserializeAnomalyAlertConfiguration(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string anomalyAlertingConfigurationId = default;
            string name = default;
            string description = default;
            MetricAlertConfigurationsOperator? crossMetricsOperator = default;
            IList<string> splitAlertByDimensions = default;
            IList<string> hookIds = default;
            IList<MetricAlertConfiguration> metricAlertingConfigurations = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("anomalyAlertingConfigurationId"u8))
                {
                    anomalyAlertingConfigurationId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("description"u8))
                {
                    description = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("crossMetricsOperator"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    crossMetricsOperator = new MetricAlertConfigurationsOperator(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("splitAlertByDimensions"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    splitAlertByDimensions = array;
                    continue;
                }
                if (property.NameEquals("hookIds"u8))
                {
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    hookIds = array;
                    continue;
                }
                if (property.NameEquals("metricAlertingConfigurations"u8))
                {
                    List<MetricAlertConfiguration> array = new List<MetricAlertConfiguration>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MetricAlertConfiguration.DeserializeMetricAlertConfiguration(item));
                    }
                    metricAlertingConfigurations = array;
                    continue;
                }
            }
            return new AnomalyAlertConfiguration(
                anomalyAlertingConfigurationId,
                name,
                description,
                crossMetricsOperator,
                splitAlertByDimensions ?? new ChangeTrackingList<string>(),
                hookIds,
                metricAlertingConfigurations);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AnomalyAlertConfiguration FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAnomalyAlertConfiguration(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
