// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.AI.MetricsAdvisor
{
    internal static partial class AlertQueryTimeModeExtensions
    {
        public static string ToSerialString(this AlertQueryTimeMode value) => value switch
        {
            AlertQueryTimeMode.AnomalyDetectedOn => "AnomalyTime",
            AlertQueryTimeMode.CreatedOn => "CreatedTime",
            AlertQueryTimeMode.LastModified => "ModifiedTime",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown AlertQueryTimeMode value.")
        };

        public static AlertQueryTimeMode ToAlertQueryTimeMode(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "AnomalyTime")) return AlertQueryTimeMode.AnomalyDetectedOn;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "CreatedTime")) return AlertQueryTimeMode.CreatedOn;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ModifiedTime")) return AlertQueryTimeMode.LastModified;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown AlertQueryTimeMode value.");
        }
    }
}
