// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.AI.MetricsAdvisor.Administration;
using Azure.AI.MetricsAdvisor.Models;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.AI.MetricsAdvisor
{
    internal partial class MicrosoftAzureMetricsAdvisorRestAPIOpenAPIV2RestClient
    {
        private readonly HttpPipeline _pipeline;
        private readonly string _endpoint;

        /// <summary> The ClientDiagnostics is used to provide tracing support for the client library. </summary>
        internal ClientDiagnostics ClientDiagnostics { get; }

        /// <summary> Initializes a new instance of MicrosoftAzureMetricsAdvisorRestAPIOpenAPIV2RestClient. </summary>
        /// <param name="clientDiagnostics"> The handler for diagnostic messaging in the client. </param>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="endpoint"> Supported Cognitive Services endpoints (protocol and hostname, for example: https://&lt;resource-name&gt;.cognitiveservices.azure.com). </param>
        /// <exception cref="ArgumentNullException"> <paramref name="clientDiagnostics"/>, <paramref name="pipeline"/> or <paramref name="endpoint"/> is null. </exception>
        public MicrosoftAzureMetricsAdvisorRestAPIOpenAPIV2RestClient(ClientDiagnostics clientDiagnostics, HttpPipeline pipeline, string endpoint)
        {
            ClientDiagnostics = clientDiagnostics ?? throw new ArgumentNullException(nameof(clientDiagnostics));
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? throw new ArgumentNullException(nameof(endpoint));
        }

        internal HttpMessage CreateGetActiveSeriesCountRequest()
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/stats/latest", false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Get latest usage stats. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<UsageStats>> GetActiveSeriesCountAsync(CancellationToken cancellationToken = default)
        {
            using var message = CreateGetActiveSeriesCountRequest();
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        UsageStats value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = UsageStats.DeserializeUsageStats(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get latest usage stats. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<UsageStats> GetActiveSeriesCount(CancellationToken cancellationToken = default)
        {
            using var message = CreateGetActiveSeriesCountRequest();
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        UsageStats value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = UsageStats.DeserializeUsageStats(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetAnomalyAlertingConfigurationRequest(Guid configurationId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/alert/anomaly/configurations/", false);
            uri.AppendPath(configurationId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Query a single anomaly alerting configuration. </summary>
        /// <param name="configurationId"> anomaly alerting configuration unique id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<AnomalyAlertConfiguration>> GetAnomalyAlertingConfigurationAsync(Guid configurationId, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetAnomalyAlertingConfigurationRequest(configurationId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnomalyAlertConfiguration value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AnomalyAlertConfiguration.DeserializeAnomalyAlertConfiguration(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Query a single anomaly alerting configuration. </summary>
        /// <param name="configurationId"> anomaly alerting configuration unique id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<AnomalyAlertConfiguration> GetAnomalyAlertingConfiguration(Guid configurationId, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetAnomalyAlertingConfigurationRequest(configurationId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnomalyAlertConfiguration value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AnomalyAlertConfiguration.DeserializeAnomalyAlertConfiguration(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateUpdateAnomalyAlertingConfigurationRequest(Guid configurationId, AnomalyAlertingConfigurationPatch body)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Patch;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/alert/anomaly/configurations/", false);
            uri.AppendPath(configurationId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/merge-patch+json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> Update anomaly alerting configuration. </summary>
        /// <param name="configurationId"> anomaly alerting configuration unique id. </param>
        /// <param name="body"> anomaly alerting configuration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public async Task<Response<AnomalyAlertConfiguration>> UpdateAnomalyAlertingConfigurationAsync(Guid configurationId, AnomalyAlertingConfigurationPatch body, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateUpdateAnomalyAlertingConfigurationRequest(configurationId, body);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnomalyAlertConfiguration value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AnomalyAlertConfiguration.DeserializeAnomalyAlertConfiguration(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Update anomaly alerting configuration. </summary>
        /// <param name="configurationId"> anomaly alerting configuration unique id. </param>
        /// <param name="body"> anomaly alerting configuration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public Response<AnomalyAlertConfiguration> UpdateAnomalyAlertingConfiguration(Guid configurationId, AnomalyAlertingConfigurationPatch body, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateUpdateAnomalyAlertingConfigurationRequest(configurationId, body);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnomalyAlertConfiguration value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AnomalyAlertConfiguration.DeserializeAnomalyAlertConfiguration(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateDeleteAnomalyAlertingConfigurationRequest(Guid configurationId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/alert/anomaly/configurations/", false);
            uri.AppendPath(configurationId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Delete anomaly alerting configuration. </summary>
        /// <param name="configurationId"> anomaly alerting configuration unique id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response> DeleteAnomalyAlertingConfigurationAsync(Guid configurationId, CancellationToken cancellationToken = default)
        {
            using var message = CreateDeleteAnomalyAlertingConfigurationRequest(configurationId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Delete anomaly alerting configuration. </summary>
        /// <param name="configurationId"> anomaly alerting configuration unique id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response DeleteAnomalyAlertingConfiguration(Guid configurationId, CancellationToken cancellationToken = default)
        {
            using var message = CreateDeleteAnomalyAlertingConfigurationRequest(configurationId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateCreateAnomalyAlertingConfigurationRequest(AnomalyAlertConfiguration body)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/alert/anomaly/configurations", false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> Create anomaly alerting configuration. </summary>
        /// <param name="body"> anomaly alerting configuration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public async Task<ResponseWithHeaders<MicrosoftAzureMetricsAdvisorRestAPIOpenAPIV2CreateAnomalyAlertingConfigurationHeaders>> CreateAnomalyAlertingConfigurationAsync(AnomalyAlertConfiguration body, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateCreateAnomalyAlertingConfigurationRequest(body);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new MicrosoftAzureMetricsAdvisorRestAPIOpenAPIV2CreateAnomalyAlertingConfigurationHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 201:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Create anomaly alerting configuration. </summary>
        /// <param name="body"> anomaly alerting configuration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public ResponseWithHeaders<MicrosoftAzureMetricsAdvisorRestAPIOpenAPIV2CreateAnomalyAlertingConfigurationHeaders> CreateAnomalyAlertingConfiguration(AnomalyAlertConfiguration body, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateCreateAnomalyAlertingConfigurationRequest(body);
            _pipeline.Send(message, cancellationToken);
            var headers = new MicrosoftAzureMetricsAdvisorRestAPIOpenAPIV2CreateAnomalyAlertingConfigurationHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 201:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetAlertsByAnomalyAlertingConfigurationRequest(Guid configurationId, AlertingResultQuery body, int? skip, int? maxpagesize)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/alert/anomaly/configurations/", false);
            uri.AppendPath(configurationId, true);
            uri.AppendPath("/alerts/query", false);
            if (skip != null)
            {
                uri.AppendQuery("$skip", skip.Value, true);
            }
            if (maxpagesize != null)
            {
                uri.AppendQuery("$maxpagesize", maxpagesize.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> Query alerts under anomaly alerting configuration. </summary>
        /// <param name="configurationId"> anomaly alerting configuration unique id. </param>
        /// <param name="body"> query alerting result request. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public async Task<Response<AlertResultList>> GetAlertsByAnomalyAlertingConfigurationAsync(Guid configurationId, AlertingResultQuery body, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetAlertsByAnomalyAlertingConfigurationRequest(configurationId, body, skip, maxpagesize);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AlertResultList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AlertResultList.DeserializeAlertResultList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Query alerts under anomaly alerting configuration. </summary>
        /// <param name="configurationId"> anomaly alerting configuration unique id. </param>
        /// <param name="body"> query alerting result request. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public Response<AlertResultList> GetAlertsByAnomalyAlertingConfiguration(Guid configurationId, AlertingResultQuery body, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetAlertsByAnomalyAlertingConfigurationRequest(configurationId, body, skip, maxpagesize);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AlertResultList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AlertResultList.DeserializeAlertResultList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetAnomaliesFromAlertByAnomalyAlertingConfigurationRequest(Guid configurationId, string alertId, int? skip, int? maxpagesize)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/alert/anomaly/configurations/", false);
            uri.AppendPath(configurationId, true);
            uri.AppendPath("/alerts/", false);
            uri.AppendPath(alertId, true);
            uri.AppendPath("/anomalies", false);
            if (skip != null)
            {
                uri.AppendQuery("$skip", skip.Value, true);
            }
            if (maxpagesize != null)
            {
                uri.AppendQuery("$maxpagesize", maxpagesize.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Query anomalies under a specific alert. </summary>
        /// <param name="configurationId"> anomaly alerting configuration unique id. </param>
        /// <param name="alertId"> alert id. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="alertId"/> is null. </exception>
        public async Task<Response<AnomalyResultList>> GetAnomaliesFromAlertByAnomalyAlertingConfigurationAsync(Guid configurationId, string alertId, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (alertId == null)
            {
                throw new ArgumentNullException(nameof(alertId));
            }

            using var message = CreateGetAnomaliesFromAlertByAnomalyAlertingConfigurationRequest(configurationId, alertId, skip, maxpagesize);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnomalyResultList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AnomalyResultList.DeserializeAnomalyResultList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Query anomalies under a specific alert. </summary>
        /// <param name="configurationId"> anomaly alerting configuration unique id. </param>
        /// <param name="alertId"> alert id. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="alertId"/> is null. </exception>
        public Response<AnomalyResultList> GetAnomaliesFromAlertByAnomalyAlertingConfiguration(Guid configurationId, string alertId, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (alertId == null)
            {
                throw new ArgumentNullException(nameof(alertId));
            }

            using var message = CreateGetAnomaliesFromAlertByAnomalyAlertingConfigurationRequest(configurationId, alertId, skip, maxpagesize);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnomalyResultList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AnomalyResultList.DeserializeAnomalyResultList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetIncidentsFromAlertByAnomalyAlertingConfigurationRequest(Guid configurationId, string alertId, int? skip, int? maxpagesize)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/alert/anomaly/configurations/", false);
            uri.AppendPath(configurationId, true);
            uri.AppendPath("/alerts/", false);
            uri.AppendPath(alertId, true);
            uri.AppendPath("/incidents", false);
            if (skip != null)
            {
                uri.AppendQuery("$skip", skip.Value, true);
            }
            if (maxpagesize != null)
            {
                uri.AppendQuery("$maxpagesize", maxpagesize.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Query incidents under a specific alert. </summary>
        /// <param name="configurationId"> anomaly alerting configuration unique id. </param>
        /// <param name="alertId"> alert id. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="alertId"/> is null. </exception>
        public async Task<Response<IncidentResultList>> GetIncidentsFromAlertByAnomalyAlertingConfigurationAsync(Guid configurationId, string alertId, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (alertId == null)
            {
                throw new ArgumentNullException(nameof(alertId));
            }

            using var message = CreateGetIncidentsFromAlertByAnomalyAlertingConfigurationRequest(configurationId, alertId, skip, maxpagesize);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        IncidentResultList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = IncidentResultList.DeserializeIncidentResultList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Query incidents under a specific alert. </summary>
        /// <param name="configurationId"> anomaly alerting configuration unique id. </param>
        /// <param name="alertId"> alert id. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="alertId"/> is null. </exception>
        public Response<IncidentResultList> GetIncidentsFromAlertByAnomalyAlertingConfiguration(Guid configurationId, string alertId, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (alertId == null)
            {
                throw new ArgumentNullException(nameof(alertId));
            }

            using var message = CreateGetIncidentsFromAlertByAnomalyAlertingConfigurationRequest(configurationId, alertId, skip, maxpagesize);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        IncidentResultList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = IncidentResultList.DeserializeIncidentResultList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetAnomalyDetectionConfigurationRequest(Guid configurationId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/enrichment/anomalyDetection/configurations/", false);
            uri.AppendPath(configurationId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Query a single anomaly detection configuration. </summary>
        /// <param name="configurationId"> anomaly detection configuration unique id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<AnomalyDetectionConfiguration>> GetAnomalyDetectionConfigurationAsync(Guid configurationId, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetAnomalyDetectionConfigurationRequest(configurationId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnomalyDetectionConfiguration value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AnomalyDetectionConfiguration.DeserializeAnomalyDetectionConfiguration(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Query a single anomaly detection configuration. </summary>
        /// <param name="configurationId"> anomaly detection configuration unique id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<AnomalyDetectionConfiguration> GetAnomalyDetectionConfiguration(Guid configurationId, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetAnomalyDetectionConfigurationRequest(configurationId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnomalyDetectionConfiguration value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AnomalyDetectionConfiguration.DeserializeAnomalyDetectionConfiguration(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateUpdateAnomalyDetectionConfigurationRequest(Guid configurationId, AnomalyDetectionConfigurationPatch body)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Patch;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/enrichment/anomalyDetection/configurations/", false);
            uri.AppendPath(configurationId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/merge-patch+json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> Update anomaly detection configuration. </summary>
        /// <param name="configurationId"> anomaly detection configuration unique id. </param>
        /// <param name="body"> anomaly detection configuration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public async Task<Response<AnomalyDetectionConfiguration>> UpdateAnomalyDetectionConfigurationAsync(Guid configurationId, AnomalyDetectionConfigurationPatch body, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateUpdateAnomalyDetectionConfigurationRequest(configurationId, body);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnomalyDetectionConfiguration value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AnomalyDetectionConfiguration.DeserializeAnomalyDetectionConfiguration(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Update anomaly detection configuration. </summary>
        /// <param name="configurationId"> anomaly detection configuration unique id. </param>
        /// <param name="body"> anomaly detection configuration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public Response<AnomalyDetectionConfiguration> UpdateAnomalyDetectionConfiguration(Guid configurationId, AnomalyDetectionConfigurationPatch body, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateUpdateAnomalyDetectionConfigurationRequest(configurationId, body);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnomalyDetectionConfiguration value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AnomalyDetectionConfiguration.DeserializeAnomalyDetectionConfiguration(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateDeleteAnomalyDetectionConfigurationRequest(Guid configurationId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/enrichment/anomalyDetection/configurations/", false);
            uri.AppendPath(configurationId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Delete anomaly detection configuration. </summary>
        /// <param name="configurationId"> anomaly detection configuration unique id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response> DeleteAnomalyDetectionConfigurationAsync(Guid configurationId, CancellationToken cancellationToken = default)
        {
            using var message = CreateDeleteAnomalyDetectionConfigurationRequest(configurationId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Delete anomaly detection configuration. </summary>
        /// <param name="configurationId"> anomaly detection configuration unique id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response DeleteAnomalyDetectionConfiguration(Guid configurationId, CancellationToken cancellationToken = default)
        {
            using var message = CreateDeleteAnomalyDetectionConfigurationRequest(configurationId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateCreateAnomalyDetectionConfigurationRequest(AnomalyDetectionConfiguration body)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/enrichment/anomalyDetection/configurations", false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> Create anomaly detection configuration. </summary>
        /// <param name="body"> anomaly detection configuration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public async Task<ResponseWithHeaders<MicrosoftAzureMetricsAdvisorRestAPIOpenAPIV2CreateAnomalyDetectionConfigurationHeaders>> CreateAnomalyDetectionConfigurationAsync(AnomalyDetectionConfiguration body, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateCreateAnomalyDetectionConfigurationRequest(body);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new MicrosoftAzureMetricsAdvisorRestAPIOpenAPIV2CreateAnomalyDetectionConfigurationHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 201:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Create anomaly detection configuration. </summary>
        /// <param name="body"> anomaly detection configuration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public ResponseWithHeaders<MicrosoftAzureMetricsAdvisorRestAPIOpenAPIV2CreateAnomalyDetectionConfigurationHeaders> CreateAnomalyDetectionConfiguration(AnomalyDetectionConfiguration body, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateCreateAnomalyDetectionConfigurationRequest(body);
            _pipeline.Send(message, cancellationToken);
            var headers = new MicrosoftAzureMetricsAdvisorRestAPIOpenAPIV2CreateAnomalyDetectionConfigurationHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 201:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationRequest(Guid configurationId, int? skip, int? maxpagesize)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/enrichment/anomalyDetection/configurations/", false);
            uri.AppendPath(configurationId, true);
            uri.AppendPath("/alert/anomaly/configurations", false);
            if (skip != null)
            {
                uri.AppendQuery("$skip", skip.Value, true);
            }
            if (maxpagesize != null)
            {
                uri.AppendQuery("$maxpagesize", maxpagesize.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> List all anomaly alerting configurations for specific anomaly detection configuration. </summary>
        /// <param name="configurationId"> anomaly detection configuration unique id. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<AnomalyAlertingConfigurationList>> GetAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationAsync(Guid configurationId, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationRequest(configurationId, skip, maxpagesize);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnomalyAlertingConfigurationList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AnomalyAlertingConfigurationList.DeserializeAnomalyAlertingConfigurationList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List all anomaly alerting configurations for specific anomaly detection configuration. </summary>
        /// <param name="configurationId"> anomaly detection configuration unique id. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<AnomalyAlertingConfigurationList> GetAnomalyAlertingConfigurationsByAnomalyDetectionConfiguration(Guid configurationId, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationRequest(configurationId, skip, maxpagesize);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnomalyAlertingConfigurationList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AnomalyAlertingConfigurationList.DeserializeAnomalyAlertingConfigurationList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetSeriesByAnomalyDetectionConfigurationRequest(Guid configurationId, DetectionSeriesQuery body)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/enrichment/anomalyDetection/configurations/", false);
            uri.AppendPath(configurationId, true);
            uri.AppendPath("/series/query", false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> Query series enriched by anomaly detection. </summary>
        /// <param name="configurationId"> anomaly detection configuration unique id. </param>
        /// <param name="body"> query series detection result request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public async Task<Response<SeriesResultList>> GetSeriesByAnomalyDetectionConfigurationAsync(Guid configurationId, DetectionSeriesQuery body, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetSeriesByAnomalyDetectionConfigurationRequest(configurationId, body);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SeriesResultList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SeriesResultList.DeserializeSeriesResultList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Query series enriched by anomaly detection. </summary>
        /// <param name="configurationId"> anomaly detection configuration unique id. </param>
        /// <param name="body"> query series detection result request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public Response<SeriesResultList> GetSeriesByAnomalyDetectionConfiguration(Guid configurationId, DetectionSeriesQuery body, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetSeriesByAnomalyDetectionConfigurationRequest(configurationId, body);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SeriesResultList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SeriesResultList.DeserializeSeriesResultList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetAnomaliesByAnomalyDetectionConfigurationRequest(Guid configurationId, DetectionAnomalyResultQuery body, int? skip, int? maxpagesize)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/enrichment/anomalyDetection/configurations/", false);
            uri.AppendPath(configurationId, true);
            uri.AppendPath("/anomalies/query", false);
            if (skip != null)
            {
                uri.AppendQuery("$skip", skip.Value, true);
            }
            if (maxpagesize != null)
            {
                uri.AppendQuery("$maxpagesize", maxpagesize.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> Query anomalies under anomaly detection configuration. </summary>
        /// <param name="configurationId"> anomaly detection configuration unique id. </param>
        /// <param name="body"> query detection anomaly result request. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public async Task<Response<AnomalyResultList>> GetAnomaliesByAnomalyDetectionConfigurationAsync(Guid configurationId, DetectionAnomalyResultQuery body, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetAnomaliesByAnomalyDetectionConfigurationRequest(configurationId, body, skip, maxpagesize);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnomalyResultList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AnomalyResultList.DeserializeAnomalyResultList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Query anomalies under anomaly detection configuration. </summary>
        /// <param name="configurationId"> anomaly detection configuration unique id. </param>
        /// <param name="body"> query detection anomaly result request. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public Response<AnomalyResultList> GetAnomaliesByAnomalyDetectionConfiguration(Guid configurationId, DetectionAnomalyResultQuery body, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetAnomaliesByAnomalyDetectionConfigurationRequest(configurationId, body, skip, maxpagesize);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnomalyResultList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AnomalyResultList.DeserializeAnomalyResultList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetDimensionOfAnomaliesByAnomalyDetectionConfigurationRequest(Guid configurationId, AnomalyDimensionQuery body, int? skip, int? maxpagesize)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/enrichment/anomalyDetection/configurations/", false);
            uri.AppendPath(configurationId, true);
            uri.AppendPath("/anomalies/dimension/query", false);
            if (skip != null)
            {
                uri.AppendQuery("$skip", skip.Value, true);
            }
            if (maxpagesize != null)
            {
                uri.AppendQuery("$maxpagesize", maxpagesize.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> Query dimension values of anomalies. </summary>
        /// <param name="configurationId"> anomaly detection configuration unique id. </param>
        /// <param name="body"> query dimension values request. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public async Task<Response<AnomalyDimensionList>> GetDimensionOfAnomaliesByAnomalyDetectionConfigurationAsync(Guid configurationId, AnomalyDimensionQuery body, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetDimensionOfAnomaliesByAnomalyDetectionConfigurationRequest(configurationId, body, skip, maxpagesize);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnomalyDimensionList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AnomalyDimensionList.DeserializeAnomalyDimensionList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Query dimension values of anomalies. </summary>
        /// <param name="configurationId"> anomaly detection configuration unique id. </param>
        /// <param name="body"> query dimension values request. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public Response<AnomalyDimensionList> GetDimensionOfAnomaliesByAnomalyDetectionConfiguration(Guid configurationId, AnomalyDimensionQuery body, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetDimensionOfAnomaliesByAnomalyDetectionConfigurationRequest(configurationId, body, skip, maxpagesize);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnomalyDimensionList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AnomalyDimensionList.DeserializeAnomalyDimensionList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetIncidentsByAnomalyDetectionConfigurationRequest(Guid configurationId, DetectionIncidentResultQuery body, int? maxpagesize)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/enrichment/anomalyDetection/configurations/", false);
            uri.AppendPath(configurationId, true);
            uri.AppendPath("/incidents/query", false);
            if (maxpagesize != null)
            {
                uri.AppendQuery("$maxpagesize", maxpagesize.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> Query incidents under anomaly detection configuration. </summary>
        /// <param name="configurationId"> anomaly detection configuration unique id. </param>
        /// <param name="body"> query detection incident result request. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public async Task<Response<IncidentResultList>> GetIncidentsByAnomalyDetectionConfigurationAsync(Guid configurationId, DetectionIncidentResultQuery body, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetIncidentsByAnomalyDetectionConfigurationRequest(configurationId, body, maxpagesize);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        IncidentResultList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = IncidentResultList.DeserializeIncidentResultList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Query incidents under anomaly detection configuration. </summary>
        /// <param name="configurationId"> anomaly detection configuration unique id. </param>
        /// <param name="body"> query detection incident result request. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public Response<IncidentResultList> GetIncidentsByAnomalyDetectionConfiguration(Guid configurationId, DetectionIncidentResultQuery body, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetIncidentsByAnomalyDetectionConfigurationRequest(configurationId, body, maxpagesize);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        IncidentResultList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = IncidentResultList.DeserializeIncidentResultList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetIncidentsByAnomalyDetectionConfigurationNextPagesRequest(Guid configurationId, int? maxpagesize, string token)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/enrichment/anomalyDetection/configurations/", false);
            uri.AppendPath(configurationId, true);
            uri.AppendPath("/incidents/query", false);
            if (maxpagesize != null)
            {
                uri.AppendQuery("$maxpagesize", maxpagesize.Value, true);
            }
            if (token != null)
            {
                uri.AppendQuery("$token", token, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Query incidents under anomaly detection configuration. </summary>
        /// <param name="configurationId"> anomaly detection configuration unique id. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="token"> the token for getting the next page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<IncidentResultList>> GetIncidentsByAnomalyDetectionConfigurationNextPagesAsync(Guid configurationId, int? maxpagesize = null, string token = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetIncidentsByAnomalyDetectionConfigurationNextPagesRequest(configurationId, maxpagesize, token);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        IncidentResultList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = IncidentResultList.DeserializeIncidentResultList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Query incidents under anomaly detection configuration. </summary>
        /// <param name="configurationId"> anomaly detection configuration unique id. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="token"> the token for getting the next page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<IncidentResultList> GetIncidentsByAnomalyDetectionConfigurationNextPages(Guid configurationId, int? maxpagesize = null, string token = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetIncidentsByAnomalyDetectionConfigurationNextPagesRequest(configurationId, maxpagesize, token);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        IncidentResultList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = IncidentResultList.DeserializeIncidentResultList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetRootCauseOfIncidentByAnomalyDetectionConfigurationRequest(Guid configurationId, string incidentId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/enrichment/anomalyDetection/configurations/", false);
            uri.AppendPath(configurationId, true);
            uri.AppendPath("/incidents/", false);
            uri.AppendPath(incidentId, true);
            uri.AppendPath("/rootCause", false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Query root cause for incident. </summary>
        /// <param name="configurationId"> anomaly detection configuration unique id. </param>
        /// <param name="incidentId"> incident id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="incidentId"/> is null. </exception>
        public async Task<Response<RootCauseList>> GetRootCauseOfIncidentByAnomalyDetectionConfigurationAsync(Guid configurationId, string incidentId, CancellationToken cancellationToken = default)
        {
            if (incidentId == null)
            {
                throw new ArgumentNullException(nameof(incidentId));
            }

            using var message = CreateGetRootCauseOfIncidentByAnomalyDetectionConfigurationRequest(configurationId, incidentId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        RootCauseList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = RootCauseList.DeserializeRootCauseList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Query root cause for incident. </summary>
        /// <param name="configurationId"> anomaly detection configuration unique id. </param>
        /// <param name="incidentId"> incident id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="incidentId"/> is null. </exception>
        public Response<RootCauseList> GetRootCauseOfIncidentByAnomalyDetectionConfiguration(Guid configurationId, string incidentId, CancellationToken cancellationToken = default)
        {
            if (incidentId == null)
            {
                throw new ArgumentNullException(nameof(incidentId));
            }

            using var message = CreateGetRootCauseOfIncidentByAnomalyDetectionConfigurationRequest(configurationId, incidentId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        RootCauseList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = RootCauseList.DeserializeRootCauseList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateCreateCredentialRequest(DataSourceCredentialEntity body)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/credentials", false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> Create a new data source credential. </summary>
        /// <param name="body"> Create data source credential request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public async Task<ResponseWithHeaders<MicrosoftAzureMetricsAdvisorRestAPIOpenAPIV2CreateCredentialHeaders>> CreateCredentialAsync(DataSourceCredentialEntity body, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateCreateCredentialRequest(body);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new MicrosoftAzureMetricsAdvisorRestAPIOpenAPIV2CreateCredentialHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 201:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Create a new data source credential. </summary>
        /// <param name="body"> Create data source credential request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public ResponseWithHeaders<MicrosoftAzureMetricsAdvisorRestAPIOpenAPIV2CreateCredentialHeaders> CreateCredential(DataSourceCredentialEntity body, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateCreateCredentialRequest(body);
            _pipeline.Send(message, cancellationToken);
            var headers = new MicrosoftAzureMetricsAdvisorRestAPIOpenAPIV2CreateCredentialHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 201:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateListCredentialsRequest(int? skip, int? maxpagesize)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/credentials", false);
            if (skip != null)
            {
                uri.AppendQuery("$skip", skip.Value, true);
            }
            if (maxpagesize != null)
            {
                uri.AppendQuery("$maxpagesize", maxpagesize.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> List all credentials. </summary>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<DataSourceCredentialList>> ListCredentialsAsync(int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateListCredentialsRequest(skip, maxpagesize);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DataSourceCredentialList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = DataSourceCredentialList.DeserializeDataSourceCredentialList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List all credentials. </summary>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<DataSourceCredentialList> ListCredentials(int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateListCredentialsRequest(skip, maxpagesize);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DataSourceCredentialList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = DataSourceCredentialList.DeserializeDataSourceCredentialList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateUpdateCredentialRequest(Guid credentialId, DataSourceCredentialPatch body)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Patch;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/credentials/", false);
            uri.AppendPath(credentialId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/merge-patch+json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> Update a data source credential. </summary>
        /// <param name="credentialId"> Data source credential unique ID. </param>
        /// <param name="body"> Update data source credential request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public async Task<Response<DataSourceCredentialEntity>> UpdateCredentialAsync(Guid credentialId, DataSourceCredentialPatch body, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateUpdateCredentialRequest(credentialId, body);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DataSourceCredentialEntity value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = DataSourceCredentialEntity.DeserializeDataSourceCredentialEntity(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Update a data source credential. </summary>
        /// <param name="credentialId"> Data source credential unique ID. </param>
        /// <param name="body"> Update data source credential request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public Response<DataSourceCredentialEntity> UpdateCredential(Guid credentialId, DataSourceCredentialPatch body, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateUpdateCredentialRequest(credentialId, body);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DataSourceCredentialEntity value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = DataSourceCredentialEntity.DeserializeDataSourceCredentialEntity(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateDeleteCredentialRequest(Guid credentialId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/credentials/", false);
            uri.AppendPath(credentialId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Delete a data source credential. </summary>
        /// <param name="credentialId"> Data source credential unique ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response> DeleteCredentialAsync(Guid credentialId, CancellationToken cancellationToken = default)
        {
            using var message = CreateDeleteCredentialRequest(credentialId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Delete a data source credential. </summary>
        /// <param name="credentialId"> Data source credential unique ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response DeleteCredential(Guid credentialId, CancellationToken cancellationToken = default)
        {
            using var message = CreateDeleteCredentialRequest(credentialId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetCredentialRequest(Guid credentialId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/credentials/", false);
            uri.AppendPath(credentialId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Get a data source credential. </summary>
        /// <param name="credentialId"> Data source credential unique ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<DataSourceCredentialEntity>> GetCredentialAsync(Guid credentialId, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetCredentialRequest(credentialId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DataSourceCredentialEntity value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = DataSourceCredentialEntity.DeserializeDataSourceCredentialEntity(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get a data source credential. </summary>
        /// <param name="credentialId"> Data source credential unique ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<DataSourceCredentialEntity> GetCredential(Guid credentialId, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetCredentialRequest(credentialId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DataSourceCredentialEntity value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = DataSourceCredentialEntity.DeserializeDataSourceCredentialEntity(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateListDataFeedsRequest(string dataFeedName, DataFeedSourceKind? dataSourceType, DataFeedGranularityType? granularityName, DataFeedStatus? status, string creator, int? skip, int? maxpagesize)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/dataFeeds", false);
            if (dataFeedName != null)
            {
                uri.AppendQuery("dataFeedName", dataFeedName, true);
            }
            if (dataSourceType != null)
            {
                uri.AppendQuery("dataSourceType", dataSourceType.Value.ToString(), true);
            }
            if (granularityName != null)
            {
                uri.AppendQuery("granularityName", granularityName.Value.ToString(), true);
            }
            if (status != null)
            {
                uri.AppendQuery("status", status.Value.ToString(), true);
            }
            if (creator != null)
            {
                uri.AppendQuery("creator", creator, true);
            }
            if (skip != null)
            {
                uri.AppendQuery("$skip", skip.Value, true);
            }
            if (maxpagesize != null)
            {
                uri.AppendQuery("$maxpagesize", maxpagesize.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> List all data feeds. </summary>
        /// <param name="dataFeedName"> filter data feed by its name. </param>
        /// <param name="dataSourceType"> filter data feed by its source type. </param>
        /// <param name="granularityName"> filter data feed by its granularity. </param>
        /// <param name="status"> filter data feed by its status. </param>
        /// <param name="creator"> filter data feed by its creator. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<DataFeedList>> ListDataFeedsAsync(string dataFeedName = null, DataFeedSourceKind? dataSourceType = null, DataFeedGranularityType? granularityName = null, DataFeedStatus? status = null, string creator = null, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateListDataFeedsRequest(dataFeedName, dataSourceType, granularityName, status, creator, skip, maxpagesize);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DataFeedList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = DataFeedList.DeserializeDataFeedList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List all data feeds. </summary>
        /// <param name="dataFeedName"> filter data feed by its name. </param>
        /// <param name="dataSourceType"> filter data feed by its source type. </param>
        /// <param name="granularityName"> filter data feed by its granularity. </param>
        /// <param name="status"> filter data feed by its status. </param>
        /// <param name="creator"> filter data feed by its creator. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<DataFeedList> ListDataFeeds(string dataFeedName = null, DataFeedSourceKind? dataSourceType = null, DataFeedGranularityType? granularityName = null, DataFeedStatus? status = null, string creator = null, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateListDataFeedsRequest(dataFeedName, dataSourceType, granularityName, status, creator, skip, maxpagesize);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DataFeedList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = DataFeedList.DeserializeDataFeedList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateCreateDataFeedRequest(DataFeedDetail body)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/dataFeeds", false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> Create a new data feed. </summary>
        /// <param name="body"> parameters to create a data feed. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public async Task<ResponseWithHeaders<MicrosoftAzureMetricsAdvisorRestAPIOpenAPIV2CreateDataFeedHeaders>> CreateDataFeedAsync(DataFeedDetail body, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateCreateDataFeedRequest(body);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new MicrosoftAzureMetricsAdvisorRestAPIOpenAPIV2CreateDataFeedHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 201:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Create a new data feed. </summary>
        /// <param name="body"> parameters to create a data feed. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public ResponseWithHeaders<MicrosoftAzureMetricsAdvisorRestAPIOpenAPIV2CreateDataFeedHeaders> CreateDataFeed(DataFeedDetail body, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateCreateDataFeedRequest(body);
            _pipeline.Send(message, cancellationToken);
            var headers = new MicrosoftAzureMetricsAdvisorRestAPIOpenAPIV2CreateDataFeedHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 201:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetDataFeedByIdRequest(Guid dataFeedId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/dataFeeds/", false);
            uri.AppendPath(dataFeedId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Get a data feed by its id. </summary>
        /// <param name="dataFeedId"> The data feed unique id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<DataFeedDetail>> GetDataFeedByIdAsync(Guid dataFeedId, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetDataFeedByIdRequest(dataFeedId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DataFeedDetail value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = DataFeedDetail.DeserializeDataFeedDetail(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get a data feed by its id. </summary>
        /// <param name="dataFeedId"> The data feed unique id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<DataFeedDetail> GetDataFeedById(Guid dataFeedId, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetDataFeedByIdRequest(dataFeedId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DataFeedDetail value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = DataFeedDetail.DeserializeDataFeedDetail(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateUpdateDataFeedRequest(Guid dataFeedId, DataFeedDetailPatch body)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Patch;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/dataFeeds/", false);
            uri.AppendPath(dataFeedId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/merge-patch+json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> Update a data feed. </summary>
        /// <param name="dataFeedId"> The data feed unique id. </param>
        /// <param name="body"> parameters to update a data feed. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public async Task<Response<DataFeedDetail>> UpdateDataFeedAsync(Guid dataFeedId, DataFeedDetailPatch body, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateUpdateDataFeedRequest(dataFeedId, body);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DataFeedDetail value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = DataFeedDetail.DeserializeDataFeedDetail(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Update a data feed. </summary>
        /// <param name="dataFeedId"> The data feed unique id. </param>
        /// <param name="body"> parameters to update a data feed. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public Response<DataFeedDetail> UpdateDataFeed(Guid dataFeedId, DataFeedDetailPatch body, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateUpdateDataFeedRequest(dataFeedId, body);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DataFeedDetail value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = DataFeedDetail.DeserializeDataFeedDetail(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateDeleteDataFeedRequest(Guid dataFeedId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/dataFeeds/", false);
            uri.AppendPath(dataFeedId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Delete a data feed. </summary>
        /// <param name="dataFeedId"> The data feed unique id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response> DeleteDataFeedAsync(Guid dataFeedId, CancellationToken cancellationToken = default)
        {
            using var message = CreateDeleteDataFeedRequest(dataFeedId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Delete a data feed. </summary>
        /// <param name="dataFeedId"> The data feed unique id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response DeleteDataFeed(Guid dataFeedId, CancellationToken cancellationToken = default)
        {
            using var message = CreateDeleteDataFeedRequest(dataFeedId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetMetricFeedbackRequest(Guid feedbackId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/feedback/metric/", false);
            uri.AppendPath(feedbackId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Get a metric feedback by its id. </summary>
        /// <param name="feedbackId"> the unique feedback ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<MetricFeedback>> GetMetricFeedbackAsync(Guid feedbackId, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetMetricFeedbackRequest(feedbackId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MetricFeedback value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = MetricFeedback.DeserializeMetricFeedback(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get a metric feedback by its id. </summary>
        /// <param name="feedbackId"> the unique feedback ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<MetricFeedback> GetMetricFeedback(Guid feedbackId, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetMetricFeedbackRequest(feedbackId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MetricFeedback value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = MetricFeedback.DeserializeMetricFeedback(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateListMetricFeedbacksRequest(MetricFeedbackFilter body, int? skip, int? maxpagesize)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/feedback/metric/query", false);
            if (skip != null)
            {
                uri.AppendQuery("$skip", skip.Value, true);
            }
            if (maxpagesize != null)
            {
                uri.AppendQuery("$maxpagesize", maxpagesize.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> List feedback on the given metric. </summary>
        /// <param name="body"> metric feedback filter. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public async Task<Response<MetricFeedbackList>> ListMetricFeedbacksAsync(MetricFeedbackFilter body, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateListMetricFeedbacksRequest(body, skip, maxpagesize);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MetricFeedbackList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = MetricFeedbackList.DeserializeMetricFeedbackList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List feedback on the given metric. </summary>
        /// <param name="body"> metric feedback filter. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public Response<MetricFeedbackList> ListMetricFeedbacks(MetricFeedbackFilter body, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateListMetricFeedbacksRequest(body, skip, maxpagesize);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MetricFeedbackList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = MetricFeedbackList.DeserializeMetricFeedbackList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateCreateMetricFeedbackRequest(MetricFeedback body)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/feedback/metric", false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> Create a new metric feedback. </summary>
        /// <param name="body"> metric feedback. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public async Task<ResponseWithHeaders<MicrosoftAzureMetricsAdvisorRestAPIOpenAPIV2CreateMetricFeedbackHeaders>> CreateMetricFeedbackAsync(MetricFeedback body, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateCreateMetricFeedbackRequest(body);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new MicrosoftAzureMetricsAdvisorRestAPIOpenAPIV2CreateMetricFeedbackHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 201:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Create a new metric feedback. </summary>
        /// <param name="body"> metric feedback. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public ResponseWithHeaders<MicrosoftAzureMetricsAdvisorRestAPIOpenAPIV2CreateMetricFeedbackHeaders> CreateMetricFeedback(MetricFeedback body, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateCreateMetricFeedbackRequest(body);
            _pipeline.Send(message, cancellationToken);
            var headers = new MicrosoftAzureMetricsAdvisorRestAPIOpenAPIV2CreateMetricFeedbackHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 201:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateListHooksRequest(string hookName, int? skip, int? maxpagesize)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/hooks", false);
            if (hookName != null)
            {
                uri.AppendQuery("hookName", hookName, true);
            }
            if (skip != null)
            {
                uri.AppendQuery("$skip", skip.Value, true);
            }
            if (maxpagesize != null)
            {
                uri.AppendQuery("$maxpagesize", maxpagesize.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> List all hooks. </summary>
        /// <param name="hookName"> filter hook by its name. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<HookList>> ListHooksAsync(string hookName = null, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateListHooksRequest(hookName, skip, maxpagesize);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        HookList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = HookList.DeserializeHookList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List all hooks. </summary>
        /// <param name="hookName"> filter hook by its name. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<HookList> ListHooks(string hookName = null, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateListHooksRequest(hookName, skip, maxpagesize);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        HookList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = HookList.DeserializeHookList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateCreateHookRequest(NotificationHook body)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/hooks", false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> Create a new hook. </summary>
        /// <param name="body"> Create hook request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public async Task<ResponseWithHeaders<MicrosoftAzureMetricsAdvisorRestAPIOpenAPIV2CreateHookHeaders>> CreateHookAsync(NotificationHook body, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateCreateHookRequest(body);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new MicrosoftAzureMetricsAdvisorRestAPIOpenAPIV2CreateHookHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 201:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Create a new hook. </summary>
        /// <param name="body"> Create hook request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public ResponseWithHeaders<MicrosoftAzureMetricsAdvisorRestAPIOpenAPIV2CreateHookHeaders> CreateHook(NotificationHook body, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateCreateHookRequest(body);
            _pipeline.Send(message, cancellationToken);
            var headers = new MicrosoftAzureMetricsAdvisorRestAPIOpenAPIV2CreateHookHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 201:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetHookRequest(Guid hookId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/hooks/", false);
            uri.AppendPath(hookId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Get a hook by its id. </summary>
        /// <param name="hookId"> Hook unique ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<NotificationHook>> GetHookAsync(Guid hookId, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetHookRequest(hookId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        NotificationHook value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = NotificationHook.DeserializeNotificationHook(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get a hook by its id. </summary>
        /// <param name="hookId"> Hook unique ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<NotificationHook> GetHook(Guid hookId, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetHookRequest(hookId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        NotificationHook value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = NotificationHook.DeserializeNotificationHook(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateUpdateHookRequest(Guid hookId, HookInfoPatch body)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Patch;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/hooks/", false);
            uri.AppendPath(hookId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/merge-patch+json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> Update a hook. </summary>
        /// <param name="hookId"> Hook unique ID. </param>
        /// <param name="body"> Update hook request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public async Task<Response<NotificationHook>> UpdateHookAsync(Guid hookId, HookInfoPatch body, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateUpdateHookRequest(hookId, body);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        NotificationHook value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = NotificationHook.DeserializeNotificationHook(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Update a hook. </summary>
        /// <param name="hookId"> Hook unique ID. </param>
        /// <param name="body"> Update hook request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public Response<NotificationHook> UpdateHook(Guid hookId, HookInfoPatch body, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateUpdateHookRequest(hookId, body);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        NotificationHook value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = NotificationHook.DeserializeNotificationHook(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateDeleteHookRequest(Guid hookId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/hooks/", false);
            uri.AppendPath(hookId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Delete a hook. </summary>
        /// <param name="hookId"> Hook unique ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response> DeleteHookAsync(Guid hookId, CancellationToken cancellationToken = default)
        {
            using var message = CreateDeleteHookRequest(hookId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Delete a hook. </summary>
        /// <param name="hookId"> Hook unique ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response DeleteHook(Guid hookId, CancellationToken cancellationToken = default)
        {
            using var message = CreateDeleteHookRequest(hookId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetDataFeedIngestionStatusRequest(Guid dataFeedId, IngestionStatusQueryOptions body, int? skip, int? maxpagesize)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/dataFeeds/", false);
            uri.AppendPath(dataFeedId, true);
            uri.AppendPath("/ingestionStatus/query", false);
            if (skip != null)
            {
                uri.AppendQuery("$skip", skip.Value, true);
            }
            if (maxpagesize != null)
            {
                uri.AppendQuery("$maxpagesize", maxpagesize.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> Get data ingestion status by data feed. </summary>
        /// <param name="dataFeedId"> The data feed unique id. </param>
        /// <param name="body"> The query time range. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public async Task<Response<IngestionStatusList>> GetDataFeedIngestionStatusAsync(Guid dataFeedId, IngestionStatusQueryOptions body, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetDataFeedIngestionStatusRequest(dataFeedId, body, skip, maxpagesize);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        IngestionStatusList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = IngestionStatusList.DeserializeIngestionStatusList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get data ingestion status by data feed. </summary>
        /// <param name="dataFeedId"> The data feed unique id. </param>
        /// <param name="body"> The query time range. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public Response<IngestionStatusList> GetDataFeedIngestionStatus(Guid dataFeedId, IngestionStatusQueryOptions body, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetDataFeedIngestionStatusRequest(dataFeedId, body, skip, maxpagesize);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        IngestionStatusList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = IngestionStatusList.DeserializeIngestionStatusList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateResetDataFeedIngestionStatusRequest(Guid dataFeedId, IngestionProgressResetOptions body)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/dataFeeds/", false);
            uri.AppendPath(dataFeedId, true);
            uri.AppendPath("/ingestionProgress/reset", false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> Reset data ingestion status by data feed to backfill data. </summary>
        /// <param name="dataFeedId"> The data feed unique id. </param>
        /// <param name="body"> The backfill time range. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public async Task<Response> ResetDataFeedIngestionStatusAsync(Guid dataFeedId, IngestionProgressResetOptions body, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateResetDataFeedIngestionStatusRequest(dataFeedId, body);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Reset data ingestion status by data feed to backfill data. </summary>
        /// <param name="dataFeedId"> The data feed unique id. </param>
        /// <param name="body"> The backfill time range. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public Response ResetDataFeedIngestionStatus(Guid dataFeedId, IngestionProgressResetOptions body, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateResetDataFeedIngestionStatusRequest(dataFeedId, body);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetIngestionProgressRequest(Guid dataFeedId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/dataFeeds/", false);
            uri.AppendPath(dataFeedId, true);
            uri.AppendPath("/ingestionProgress", false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Get data last success ingestion job timestamp by data feed. </summary>
        /// <param name="dataFeedId"> The data feed unique id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<DataFeedIngestionProgress>> GetIngestionProgressAsync(Guid dataFeedId, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetIngestionProgressRequest(dataFeedId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DataFeedIngestionProgress value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = DataFeedIngestionProgress.DeserializeDataFeedIngestionProgress(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get data last success ingestion job timestamp by data feed. </summary>
        /// <param name="dataFeedId"> The data feed unique id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<DataFeedIngestionProgress> GetIngestionProgress(Guid dataFeedId, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetIngestionProgressRequest(dataFeedId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DataFeedIngestionProgress value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = DataFeedIngestionProgress.DeserializeDataFeedIngestionProgress(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetMetricDataRequest(Guid metricId, MetricDataQueryOptions body)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/metrics/", false);
            uri.AppendPath(metricId, true);
            uri.AppendPath("/data/query", false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> Get time series data from metric. </summary>
        /// <param name="metricId"> metric unique id. </param>
        /// <param name="body"> query time series data condition. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public async Task<Response<MetricDataList>> GetMetricDataAsync(Guid metricId, MetricDataQueryOptions body, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetMetricDataRequest(metricId, body);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MetricDataList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = MetricDataList.DeserializeMetricDataList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get time series data from metric. </summary>
        /// <param name="metricId"> metric unique id. </param>
        /// <param name="body"> query time series data condition. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public Response<MetricDataList> GetMetricData(Guid metricId, MetricDataQueryOptions body, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetMetricDataRequest(metricId, body);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MetricDataList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = MetricDataList.DeserializeMetricDataList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetMetricSeriesRequest(Guid metricId, MetricSeriesQueryOptions body, int? skip, int? maxpagesize)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/metrics/", false);
            uri.AppendPath(metricId, true);
            uri.AppendPath("/series/query", false);
            if (skip != null)
            {
                uri.AppendQuery("$skip", skip.Value, true);
            }
            if (maxpagesize != null)
            {
                uri.AppendQuery("$maxpagesize", maxpagesize.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> List series (dimension combinations) from metric. </summary>
        /// <param name="metricId"> metric unique id. </param>
        /// <param name="body"> filter to query series. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public async Task<Response<MetricSeriesList>> GetMetricSeriesAsync(Guid metricId, MetricSeriesQueryOptions body, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetMetricSeriesRequest(metricId, body, skip, maxpagesize);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MetricSeriesList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = MetricSeriesList.DeserializeMetricSeriesList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List series (dimension combinations) from metric. </summary>
        /// <param name="metricId"> metric unique id. </param>
        /// <param name="body"> filter to query series. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public Response<MetricSeriesList> GetMetricSeries(Guid metricId, MetricSeriesQueryOptions body, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetMetricSeriesRequest(metricId, body, skip, maxpagesize);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MetricSeriesList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = MetricSeriesList.DeserializeMetricSeriesList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetMetricDimensionRequest(Guid metricId, MetricDimensionQueryOptions body, int? skip, int? maxpagesize)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/metrics/", false);
            uri.AppendPath(metricId, true);
            uri.AppendPath("/dimension/query", false);
            if (skip != null)
            {
                uri.AppendQuery("$skip", skip.Value, true);
            }
            if (maxpagesize != null)
            {
                uri.AppendQuery("$maxpagesize", maxpagesize.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> List dimension from certain metric. </summary>
        /// <param name="metricId"> metric unique id. </param>
        /// <param name="body"> query dimension option. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public async Task<Response<MetricDimensionList>> GetMetricDimensionAsync(Guid metricId, MetricDimensionQueryOptions body, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetMetricDimensionRequest(metricId, body, skip, maxpagesize);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MetricDimensionList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = MetricDimensionList.DeserializeMetricDimensionList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List dimension from certain metric. </summary>
        /// <param name="metricId"> metric unique id. </param>
        /// <param name="body"> query dimension option. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public Response<MetricDimensionList> GetMetricDimension(Guid metricId, MetricDimensionQueryOptions body, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetMetricDimensionRequest(metricId, body, skip, maxpagesize);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MetricDimensionList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = MetricDimensionList.DeserializeMetricDimensionList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetAnomalyDetectionConfigurationsByMetricRequest(Guid metricId, int? skip, int? maxpagesize)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/metrics/", false);
            uri.AppendPath(metricId, true);
            uri.AppendPath("/enrichment/anomalyDetection/configurations", false);
            if (skip != null)
            {
                uri.AppendQuery("$skip", skip.Value, true);
            }
            if (maxpagesize != null)
            {
                uri.AppendQuery("$maxpagesize", maxpagesize.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> List all anomaly detection configurations for specific metric. </summary>
        /// <param name="metricId"> metric unique id. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<AnomalyDetectionConfigurationList>> GetAnomalyDetectionConfigurationsByMetricAsync(Guid metricId, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetAnomalyDetectionConfigurationsByMetricRequest(metricId, skip, maxpagesize);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnomalyDetectionConfigurationList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AnomalyDetectionConfigurationList.DeserializeAnomalyDetectionConfigurationList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List all anomaly detection configurations for specific metric. </summary>
        /// <param name="metricId"> metric unique id. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<AnomalyDetectionConfigurationList> GetAnomalyDetectionConfigurationsByMetric(Guid metricId, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetAnomalyDetectionConfigurationsByMetricRequest(metricId, skip, maxpagesize);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnomalyDetectionConfigurationList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AnomalyDetectionConfigurationList.DeserializeAnomalyDetectionConfigurationList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetEnrichmentStatusByMetricRequest(Guid metricId, EnrichmentStatusQueryOption body, int? skip, int? maxpagesize)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/metrics/", false);
            uri.AppendPath(metricId, true);
            uri.AppendPath("/status/enrichment/anomalyDetection/query", false);
            if (skip != null)
            {
                uri.AppendQuery("$skip", skip.Value, true);
            }
            if (maxpagesize != null)
            {
                uri.AppendQuery("$maxpagesize", maxpagesize.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> Query anomaly detection status. </summary>
        /// <param name="metricId"> metric unique id. </param>
        /// <param name="body"> query options. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public async Task<Response<EnrichmentStatusList>> GetEnrichmentStatusByMetricAsync(Guid metricId, EnrichmentStatusQueryOption body, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetEnrichmentStatusByMetricRequest(metricId, body, skip, maxpagesize);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        EnrichmentStatusList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = EnrichmentStatusList.DeserializeEnrichmentStatusList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Query anomaly detection status. </summary>
        /// <param name="metricId"> metric unique id. </param>
        /// <param name="body"> query options. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public Response<EnrichmentStatusList> GetEnrichmentStatusByMetric(Guid metricId, EnrichmentStatusQueryOption body, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetEnrichmentStatusByMetricRequest(metricId, body, skip, maxpagesize);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        EnrichmentStatusList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = EnrichmentStatusList.DeserializeEnrichmentStatusList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetAlertsByAnomalyAlertingConfigurationNextRequest(string nextLink, AlertingResultQuery body)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/", false);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> Query alerts under anomaly alerting configuration. </summary>
        /// <param name="nextLink"> the next link. </param>
        /// <param name="body"> query alerting result request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public async Task<Response<AlertResultList>> GetAlertsByAnomalyAlertingConfigurationNextAsync(string nextLink, AlertingResultQuery body, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetAlertsByAnomalyAlertingConfigurationNextRequest(nextLink, body);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AlertResultList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AlertResultList.DeserializeAlertResultList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Query alerts under anomaly alerting configuration. </summary>
        /// <param name="nextLink"> the next link. </param>
        /// <param name="body"> query alerting result request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public Response<AlertResultList> GetAlertsByAnomalyAlertingConfigurationNext(string nextLink, AlertingResultQuery body, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetAlertsByAnomalyAlertingConfigurationNextRequest(nextLink, body);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AlertResultList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AlertResultList.DeserializeAlertResultList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetAnomaliesByAnomalyDetectionConfigurationNextRequest(string nextLink, DetectionAnomalyResultQuery body)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/", false);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> Query anomalies under anomaly detection configuration. </summary>
        /// <param name="nextLink"> the next link. </param>
        /// <param name="body"> query detection anomaly result request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public async Task<Response<AnomalyResultList>> GetAnomaliesByAnomalyDetectionConfigurationNextAsync(string nextLink, DetectionAnomalyResultQuery body, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetAnomaliesByAnomalyDetectionConfigurationNextRequest(nextLink, body);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnomalyResultList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AnomalyResultList.DeserializeAnomalyResultList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Query anomalies under anomaly detection configuration. </summary>
        /// <param name="nextLink"> the next link. </param>
        /// <param name="body"> query detection anomaly result request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public Response<AnomalyResultList> GetAnomaliesByAnomalyDetectionConfigurationNext(string nextLink, DetectionAnomalyResultQuery body, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetAnomaliesByAnomalyDetectionConfigurationNextRequest(nextLink, body);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnomalyResultList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AnomalyResultList.DeserializeAnomalyResultList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetDimensionOfAnomaliesByAnomalyDetectionConfigurationNextRequest(string nextLink, AnomalyDimensionQuery body)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/", false);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> Query dimension values of anomalies. </summary>
        /// <param name="nextLink"> the next link. </param>
        /// <param name="body"> query dimension values request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public async Task<Response<AnomalyDimensionList>> GetDimensionOfAnomaliesByAnomalyDetectionConfigurationNextAsync(string nextLink, AnomalyDimensionQuery body, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetDimensionOfAnomaliesByAnomalyDetectionConfigurationNextRequest(nextLink, body);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnomalyDimensionList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AnomalyDimensionList.DeserializeAnomalyDimensionList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Query dimension values of anomalies. </summary>
        /// <param name="nextLink"> the next link. </param>
        /// <param name="body"> query dimension values request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public Response<AnomalyDimensionList> GetDimensionOfAnomaliesByAnomalyDetectionConfigurationNext(string nextLink, AnomalyDimensionQuery body, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetDimensionOfAnomaliesByAnomalyDetectionConfigurationNextRequest(nextLink, body);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnomalyDimensionList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AnomalyDimensionList.DeserializeAnomalyDimensionList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateListMetricFeedbacksNextRequest(string nextLink, MetricFeedbackFilter body)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/", false);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> List feedback on the given metric. </summary>
        /// <param name="nextLink"> the next link. </param>
        /// <param name="body"> metric feedback filter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public async Task<Response<MetricFeedbackList>> ListMetricFeedbacksNextAsync(string nextLink, MetricFeedbackFilter body, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateListMetricFeedbacksNextRequest(nextLink, body);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MetricFeedbackList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = MetricFeedbackList.DeserializeMetricFeedbackList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List feedback on the given metric. </summary>
        /// <param name="nextLink"> the next link. </param>
        /// <param name="body"> metric feedback filter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public Response<MetricFeedbackList> ListMetricFeedbacksNext(string nextLink, MetricFeedbackFilter body, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateListMetricFeedbacksNextRequest(nextLink, body);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MetricFeedbackList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = MetricFeedbackList.DeserializeMetricFeedbackList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetDataFeedIngestionStatusNextRequest(string nextLink, IngestionStatusQueryOptions body)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/", false);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> Get data ingestion status by data feed. </summary>
        /// <param name="nextLink"> the next link. </param>
        /// <param name="body"> The query time range. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public async Task<Response<IngestionStatusList>> GetDataFeedIngestionStatusNextAsync(string nextLink, IngestionStatusQueryOptions body, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetDataFeedIngestionStatusNextRequest(nextLink, body);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        IngestionStatusList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = IngestionStatusList.DeserializeIngestionStatusList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get data ingestion status by data feed. </summary>
        /// <param name="nextLink"> the next link. </param>
        /// <param name="body"> The query time range. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public Response<IngestionStatusList> GetDataFeedIngestionStatusNext(string nextLink, IngestionStatusQueryOptions body, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetDataFeedIngestionStatusNextRequest(nextLink, body);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        IngestionStatusList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = IngestionStatusList.DeserializeIngestionStatusList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetMetricSeriesNextRequest(string nextLink, MetricSeriesQueryOptions body)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/", false);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> List series (dimension combinations) from metric. </summary>
        /// <param name="nextLink"> the next link. </param>
        /// <param name="body"> filter to query series. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public async Task<Response<MetricSeriesList>> GetMetricSeriesNextAsync(string nextLink, MetricSeriesQueryOptions body, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetMetricSeriesNextRequest(nextLink, body);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MetricSeriesList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = MetricSeriesList.DeserializeMetricSeriesList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List series (dimension combinations) from metric. </summary>
        /// <param name="nextLink"> the next link. </param>
        /// <param name="body"> filter to query series. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public Response<MetricSeriesList> GetMetricSeriesNext(string nextLink, MetricSeriesQueryOptions body, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetMetricSeriesNextRequest(nextLink, body);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MetricSeriesList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = MetricSeriesList.DeserializeMetricSeriesList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetMetricDimensionNextRequest(string nextLink, MetricDimensionQueryOptions body)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/", false);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> List dimension from certain metric. </summary>
        /// <param name="nextLink"> the next link. </param>
        /// <param name="body"> query dimension option. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public async Task<Response<MetricDimensionList>> GetMetricDimensionNextAsync(string nextLink, MetricDimensionQueryOptions body, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetMetricDimensionNextRequest(nextLink, body);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MetricDimensionList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = MetricDimensionList.DeserializeMetricDimensionList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List dimension from certain metric. </summary>
        /// <param name="nextLink"> the next link. </param>
        /// <param name="body"> query dimension option. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public Response<MetricDimensionList> GetMetricDimensionNext(string nextLink, MetricDimensionQueryOptions body, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetMetricDimensionNextRequest(nextLink, body);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MetricDimensionList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = MetricDimensionList.DeserializeMetricDimensionList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetEnrichmentStatusByMetricNextRequest(string nextLink, EnrichmentStatusQueryOption body)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendPath("/", false);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> Query anomaly detection status. </summary>
        /// <param name="nextLink"> the next link. </param>
        /// <param name="body"> query options. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public async Task<Response<EnrichmentStatusList>> GetEnrichmentStatusByMetricNextAsync(string nextLink, EnrichmentStatusQueryOption body, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetEnrichmentStatusByMetricNextRequest(nextLink, body);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        EnrichmentStatusList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = EnrichmentStatusList.DeserializeEnrichmentStatusList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Query anomaly detection status. </summary>
        /// <param name="nextLink"> the next link. </param>
        /// <param name="body"> query options. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public Response<EnrichmentStatusList> GetEnrichmentStatusByMetricNext(string nextLink, EnrichmentStatusQueryOption body, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetEnrichmentStatusByMetricNextRequest(nextLink, body);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        EnrichmentStatusList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = EnrichmentStatusList.DeserializeEnrichmentStatusList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetAlertsByAnomalyAlertingConfigurationNextPageRequest(string nextLink, Guid configurationId, AlertingResultQuery body, int? skip, int? maxpagesize)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Query alerts under anomaly alerting configuration. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="configurationId"> anomaly alerting configuration unique id. </param>
        /// <param name="body"> query alerting result request. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public async Task<Response<AlertResultList>> GetAlertsByAnomalyAlertingConfigurationNextPageAsync(string nextLink, Guid configurationId, AlertingResultQuery body, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetAlertsByAnomalyAlertingConfigurationNextPageRequest(nextLink, configurationId, body, skip, maxpagesize);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AlertResultList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AlertResultList.DeserializeAlertResultList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Query alerts under anomaly alerting configuration. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="configurationId"> anomaly alerting configuration unique id. </param>
        /// <param name="body"> query alerting result request. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public Response<AlertResultList> GetAlertsByAnomalyAlertingConfigurationNextPage(string nextLink, Guid configurationId, AlertingResultQuery body, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetAlertsByAnomalyAlertingConfigurationNextPageRequest(nextLink, configurationId, body, skip, maxpagesize);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AlertResultList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AlertResultList.DeserializeAlertResultList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetAnomaliesFromAlertByAnomalyAlertingConfigurationNextPageRequest(string nextLink, Guid configurationId, string alertId, int? skip, int? maxpagesize)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Query anomalies under a specific alert. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="configurationId"> anomaly alerting configuration unique id. </param>
        /// <param name="alertId"> alert id. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="alertId"/> is null. </exception>
        public async Task<Response<AnomalyResultList>> GetAnomaliesFromAlertByAnomalyAlertingConfigurationNextPageAsync(string nextLink, Guid configurationId, string alertId, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (alertId == null)
            {
                throw new ArgumentNullException(nameof(alertId));
            }

            using var message = CreateGetAnomaliesFromAlertByAnomalyAlertingConfigurationNextPageRequest(nextLink, configurationId, alertId, skip, maxpagesize);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnomalyResultList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AnomalyResultList.DeserializeAnomalyResultList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Query anomalies under a specific alert. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="configurationId"> anomaly alerting configuration unique id. </param>
        /// <param name="alertId"> alert id. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="alertId"/> is null. </exception>
        public Response<AnomalyResultList> GetAnomaliesFromAlertByAnomalyAlertingConfigurationNextPage(string nextLink, Guid configurationId, string alertId, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (alertId == null)
            {
                throw new ArgumentNullException(nameof(alertId));
            }

            using var message = CreateGetAnomaliesFromAlertByAnomalyAlertingConfigurationNextPageRequest(nextLink, configurationId, alertId, skip, maxpagesize);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnomalyResultList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AnomalyResultList.DeserializeAnomalyResultList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetIncidentsFromAlertByAnomalyAlertingConfigurationNextPageRequest(string nextLink, Guid configurationId, string alertId, int? skip, int? maxpagesize)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Query incidents under a specific alert. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="configurationId"> anomaly alerting configuration unique id. </param>
        /// <param name="alertId"> alert id. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="alertId"/> is null. </exception>
        public async Task<Response<IncidentResultList>> GetIncidentsFromAlertByAnomalyAlertingConfigurationNextPageAsync(string nextLink, Guid configurationId, string alertId, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (alertId == null)
            {
                throw new ArgumentNullException(nameof(alertId));
            }

            using var message = CreateGetIncidentsFromAlertByAnomalyAlertingConfigurationNextPageRequest(nextLink, configurationId, alertId, skip, maxpagesize);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        IncidentResultList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = IncidentResultList.DeserializeIncidentResultList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Query incidents under a specific alert. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="configurationId"> anomaly alerting configuration unique id. </param>
        /// <param name="alertId"> alert id. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="alertId"/> is null. </exception>
        public Response<IncidentResultList> GetIncidentsFromAlertByAnomalyAlertingConfigurationNextPage(string nextLink, Guid configurationId, string alertId, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (alertId == null)
            {
                throw new ArgumentNullException(nameof(alertId));
            }

            using var message = CreateGetIncidentsFromAlertByAnomalyAlertingConfigurationNextPageRequest(nextLink, configurationId, alertId, skip, maxpagesize);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        IncidentResultList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = IncidentResultList.DeserializeIncidentResultList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationNextPageRequest(string nextLink, Guid configurationId, int? skip, int? maxpagesize)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> List all anomaly alerting configurations for specific anomaly detection configuration. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="configurationId"> anomaly detection configuration unique id. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        public async Task<Response<AnomalyAlertingConfigurationList>> GetAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationNextPageAsync(string nextLink, Guid configurationId, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }

            using var message = CreateGetAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationNextPageRequest(nextLink, configurationId, skip, maxpagesize);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnomalyAlertingConfigurationList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AnomalyAlertingConfigurationList.DeserializeAnomalyAlertingConfigurationList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List all anomaly alerting configurations for specific anomaly detection configuration. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="configurationId"> anomaly detection configuration unique id. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        public Response<AnomalyAlertingConfigurationList> GetAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationNextPage(string nextLink, Guid configurationId, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }

            using var message = CreateGetAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationNextPageRequest(nextLink, configurationId, skip, maxpagesize);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnomalyAlertingConfigurationList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AnomalyAlertingConfigurationList.DeserializeAnomalyAlertingConfigurationList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetAnomaliesByAnomalyDetectionConfigurationNextPageRequest(string nextLink, Guid configurationId, DetectionAnomalyResultQuery body, int? skip, int? maxpagesize)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Query anomalies under anomaly detection configuration. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="configurationId"> anomaly detection configuration unique id. </param>
        /// <param name="body"> query detection anomaly result request. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public async Task<Response<AnomalyResultList>> GetAnomaliesByAnomalyDetectionConfigurationNextPageAsync(string nextLink, Guid configurationId, DetectionAnomalyResultQuery body, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetAnomaliesByAnomalyDetectionConfigurationNextPageRequest(nextLink, configurationId, body, skip, maxpagesize);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnomalyResultList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AnomalyResultList.DeserializeAnomalyResultList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Query anomalies under anomaly detection configuration. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="configurationId"> anomaly detection configuration unique id. </param>
        /// <param name="body"> query detection anomaly result request. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public Response<AnomalyResultList> GetAnomaliesByAnomalyDetectionConfigurationNextPage(string nextLink, Guid configurationId, DetectionAnomalyResultQuery body, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetAnomaliesByAnomalyDetectionConfigurationNextPageRequest(nextLink, configurationId, body, skip, maxpagesize);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnomalyResultList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AnomalyResultList.DeserializeAnomalyResultList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetDimensionOfAnomaliesByAnomalyDetectionConfigurationNextPageRequest(string nextLink, Guid configurationId, AnomalyDimensionQuery body, int? skip, int? maxpagesize)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Query dimension values of anomalies. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="configurationId"> anomaly detection configuration unique id. </param>
        /// <param name="body"> query dimension values request. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public async Task<Response<AnomalyDimensionList>> GetDimensionOfAnomaliesByAnomalyDetectionConfigurationNextPageAsync(string nextLink, Guid configurationId, AnomalyDimensionQuery body, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetDimensionOfAnomaliesByAnomalyDetectionConfigurationNextPageRequest(nextLink, configurationId, body, skip, maxpagesize);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnomalyDimensionList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AnomalyDimensionList.DeserializeAnomalyDimensionList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Query dimension values of anomalies. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="configurationId"> anomaly detection configuration unique id. </param>
        /// <param name="body"> query dimension values request. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public Response<AnomalyDimensionList> GetDimensionOfAnomaliesByAnomalyDetectionConfigurationNextPage(string nextLink, Guid configurationId, AnomalyDimensionQuery body, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetDimensionOfAnomaliesByAnomalyDetectionConfigurationNextPageRequest(nextLink, configurationId, body, skip, maxpagesize);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnomalyDimensionList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AnomalyDimensionList.DeserializeAnomalyDimensionList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetIncidentsByAnomalyDetectionConfigurationNextPageRequest(string nextLink, Guid configurationId, DetectionIncidentResultQuery body, int? maxpagesize)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Query incidents under anomaly detection configuration. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="configurationId"> anomaly detection configuration unique id. </param>
        /// <param name="body"> query detection incident result request. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public async Task<Response<IncidentResultList>> GetIncidentsByAnomalyDetectionConfigurationNextPageAsync(string nextLink, Guid configurationId, DetectionIncidentResultQuery body, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetIncidentsByAnomalyDetectionConfigurationNextPageRequest(nextLink, configurationId, body, maxpagesize);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        IncidentResultList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = IncidentResultList.DeserializeIncidentResultList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Query incidents under anomaly detection configuration. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="configurationId"> anomaly detection configuration unique id. </param>
        /// <param name="body"> query detection incident result request. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public Response<IncidentResultList> GetIncidentsByAnomalyDetectionConfigurationNextPage(string nextLink, Guid configurationId, DetectionIncidentResultQuery body, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetIncidentsByAnomalyDetectionConfigurationNextPageRequest(nextLink, configurationId, body, maxpagesize);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        IncidentResultList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = IncidentResultList.DeserializeIncidentResultList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetIncidentsByAnomalyDetectionConfigurationNextPagesNextPageRequest(string nextLink, Guid configurationId, int? maxpagesize, string token)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Query incidents under anomaly detection configuration. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="configurationId"> anomaly detection configuration unique id. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="token"> the token for getting the next page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        public async Task<Response<IncidentResultList>> GetIncidentsByAnomalyDetectionConfigurationNextPagesNextPageAsync(string nextLink, Guid configurationId, int? maxpagesize = null, string token = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }

            using var message = CreateGetIncidentsByAnomalyDetectionConfigurationNextPagesNextPageRequest(nextLink, configurationId, maxpagesize, token);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        IncidentResultList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = IncidentResultList.DeserializeIncidentResultList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Query incidents under anomaly detection configuration. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="configurationId"> anomaly detection configuration unique id. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="token"> the token for getting the next page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        public Response<IncidentResultList> GetIncidentsByAnomalyDetectionConfigurationNextPagesNextPage(string nextLink, Guid configurationId, int? maxpagesize = null, string token = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }

            using var message = CreateGetIncidentsByAnomalyDetectionConfigurationNextPagesNextPageRequest(nextLink, configurationId, maxpagesize, token);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        IncidentResultList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = IncidentResultList.DeserializeIncidentResultList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateListCredentialsNextPageRequest(string nextLink, int? skip, int? maxpagesize)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> List all credentials. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        public async Task<Response<DataSourceCredentialList>> ListCredentialsNextPageAsync(string nextLink, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }

            using var message = CreateListCredentialsNextPageRequest(nextLink, skip, maxpagesize);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DataSourceCredentialList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = DataSourceCredentialList.DeserializeDataSourceCredentialList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List all credentials. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        public Response<DataSourceCredentialList> ListCredentialsNextPage(string nextLink, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }

            using var message = CreateListCredentialsNextPageRequest(nextLink, skip, maxpagesize);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DataSourceCredentialList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = DataSourceCredentialList.DeserializeDataSourceCredentialList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateListDataFeedsNextPageRequest(string nextLink, string dataFeedName, DataFeedSourceKind? dataSourceType, DataFeedGranularityType? granularityName, DataFeedStatus? status, string creator, int? skip, int? maxpagesize)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> List all data feeds. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="dataFeedName"> filter data feed by its name. </param>
        /// <param name="dataSourceType"> filter data feed by its source type. </param>
        /// <param name="granularityName"> filter data feed by its granularity. </param>
        /// <param name="status"> filter data feed by its status. </param>
        /// <param name="creator"> filter data feed by its creator. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        public async Task<Response<DataFeedList>> ListDataFeedsNextPageAsync(string nextLink, string dataFeedName = null, DataFeedSourceKind? dataSourceType = null, DataFeedGranularityType? granularityName = null, DataFeedStatus? status = null, string creator = null, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }

            using var message = CreateListDataFeedsNextPageRequest(nextLink, dataFeedName, dataSourceType, granularityName, status, creator, skip, maxpagesize);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DataFeedList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = DataFeedList.DeserializeDataFeedList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List all data feeds. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="dataFeedName"> filter data feed by its name. </param>
        /// <param name="dataSourceType"> filter data feed by its source type. </param>
        /// <param name="granularityName"> filter data feed by its granularity. </param>
        /// <param name="status"> filter data feed by its status. </param>
        /// <param name="creator"> filter data feed by its creator. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        public Response<DataFeedList> ListDataFeedsNextPage(string nextLink, string dataFeedName = null, DataFeedSourceKind? dataSourceType = null, DataFeedGranularityType? granularityName = null, DataFeedStatus? status = null, string creator = null, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }

            using var message = CreateListDataFeedsNextPageRequest(nextLink, dataFeedName, dataSourceType, granularityName, status, creator, skip, maxpagesize);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DataFeedList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = DataFeedList.DeserializeDataFeedList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateListMetricFeedbacksNextPageRequest(string nextLink, MetricFeedbackFilter body, int? skip, int? maxpagesize)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> List feedback on the given metric. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="body"> metric feedback filter. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public async Task<Response<MetricFeedbackList>> ListMetricFeedbacksNextPageAsync(string nextLink, MetricFeedbackFilter body, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateListMetricFeedbacksNextPageRequest(nextLink, body, skip, maxpagesize);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MetricFeedbackList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = MetricFeedbackList.DeserializeMetricFeedbackList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List feedback on the given metric. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="body"> metric feedback filter. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public Response<MetricFeedbackList> ListMetricFeedbacksNextPage(string nextLink, MetricFeedbackFilter body, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateListMetricFeedbacksNextPageRequest(nextLink, body, skip, maxpagesize);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MetricFeedbackList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = MetricFeedbackList.DeserializeMetricFeedbackList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateListHooksNextPageRequest(string nextLink, string hookName, int? skip, int? maxpagesize)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> List all hooks. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="hookName"> filter hook by its name. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        public async Task<Response<HookList>> ListHooksNextPageAsync(string nextLink, string hookName = null, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }

            using var message = CreateListHooksNextPageRequest(nextLink, hookName, skip, maxpagesize);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        HookList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = HookList.DeserializeHookList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List all hooks. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="hookName"> filter hook by its name. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        public Response<HookList> ListHooksNextPage(string nextLink, string hookName = null, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }

            using var message = CreateListHooksNextPageRequest(nextLink, hookName, skip, maxpagesize);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        HookList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = HookList.DeserializeHookList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetDataFeedIngestionStatusNextPageRequest(string nextLink, Guid dataFeedId, IngestionStatusQueryOptions body, int? skip, int? maxpagesize)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Get data ingestion status by data feed. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="dataFeedId"> The data feed unique id. </param>
        /// <param name="body"> The query time range. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public async Task<Response<IngestionStatusList>> GetDataFeedIngestionStatusNextPageAsync(string nextLink, Guid dataFeedId, IngestionStatusQueryOptions body, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetDataFeedIngestionStatusNextPageRequest(nextLink, dataFeedId, body, skip, maxpagesize);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        IngestionStatusList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = IngestionStatusList.DeserializeIngestionStatusList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get data ingestion status by data feed. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="dataFeedId"> The data feed unique id. </param>
        /// <param name="body"> The query time range. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public Response<IngestionStatusList> GetDataFeedIngestionStatusNextPage(string nextLink, Guid dataFeedId, IngestionStatusQueryOptions body, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetDataFeedIngestionStatusNextPageRequest(nextLink, dataFeedId, body, skip, maxpagesize);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        IngestionStatusList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = IngestionStatusList.DeserializeIngestionStatusList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetMetricSeriesNextPageRequest(string nextLink, Guid metricId, MetricSeriesQueryOptions body, int? skip, int? maxpagesize)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> List series (dimension combinations) from metric. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="metricId"> metric unique id. </param>
        /// <param name="body"> filter to query series. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public async Task<Response<MetricSeriesList>> GetMetricSeriesNextPageAsync(string nextLink, Guid metricId, MetricSeriesQueryOptions body, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetMetricSeriesNextPageRequest(nextLink, metricId, body, skip, maxpagesize);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MetricSeriesList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = MetricSeriesList.DeserializeMetricSeriesList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List series (dimension combinations) from metric. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="metricId"> metric unique id. </param>
        /// <param name="body"> filter to query series. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public Response<MetricSeriesList> GetMetricSeriesNextPage(string nextLink, Guid metricId, MetricSeriesQueryOptions body, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetMetricSeriesNextPageRequest(nextLink, metricId, body, skip, maxpagesize);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MetricSeriesList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = MetricSeriesList.DeserializeMetricSeriesList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetMetricDimensionNextPageRequest(string nextLink, Guid metricId, MetricDimensionQueryOptions body, int? skip, int? maxpagesize)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> List dimension from certain metric. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="metricId"> metric unique id. </param>
        /// <param name="body"> query dimension option. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public async Task<Response<MetricDimensionList>> GetMetricDimensionNextPageAsync(string nextLink, Guid metricId, MetricDimensionQueryOptions body, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetMetricDimensionNextPageRequest(nextLink, metricId, body, skip, maxpagesize);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MetricDimensionList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = MetricDimensionList.DeserializeMetricDimensionList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List dimension from certain metric. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="metricId"> metric unique id. </param>
        /// <param name="body"> query dimension option. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public Response<MetricDimensionList> GetMetricDimensionNextPage(string nextLink, Guid metricId, MetricDimensionQueryOptions body, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetMetricDimensionNextPageRequest(nextLink, metricId, body, skip, maxpagesize);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MetricDimensionList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = MetricDimensionList.DeserializeMetricDimensionList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetAnomalyDetectionConfigurationsByMetricNextPageRequest(string nextLink, Guid metricId, int? skip, int? maxpagesize)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> List all anomaly detection configurations for specific metric. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="metricId"> metric unique id. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        public async Task<Response<AnomalyDetectionConfigurationList>> GetAnomalyDetectionConfigurationsByMetricNextPageAsync(string nextLink, Guid metricId, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }

            using var message = CreateGetAnomalyDetectionConfigurationsByMetricNextPageRequest(nextLink, metricId, skip, maxpagesize);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnomalyDetectionConfigurationList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AnomalyDetectionConfigurationList.DeserializeAnomalyDetectionConfigurationList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List all anomaly detection configurations for specific metric. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="metricId"> metric unique id. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        public Response<AnomalyDetectionConfigurationList> GetAnomalyDetectionConfigurationsByMetricNextPage(string nextLink, Guid metricId, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }

            using var message = CreateGetAnomalyDetectionConfigurationsByMetricNextPageRequest(nextLink, metricId, skip, maxpagesize);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnomalyDetectionConfigurationList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AnomalyDetectionConfigurationList.DeserializeAnomalyDetectionConfigurationList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetEnrichmentStatusByMetricNextPageRequest(string nextLink, Guid metricId, EnrichmentStatusQueryOption body, int? skip, int? maxpagesize)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRaw("/metricsadvisor/v1.0", false);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Query anomaly detection status. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="metricId"> metric unique id. </param>
        /// <param name="body"> query options. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public async Task<Response<EnrichmentStatusList>> GetEnrichmentStatusByMetricNextPageAsync(string nextLink, Guid metricId, EnrichmentStatusQueryOption body, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetEnrichmentStatusByMetricNextPageRequest(nextLink, metricId, body, skip, maxpagesize);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        EnrichmentStatusList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = EnrichmentStatusList.DeserializeEnrichmentStatusList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Query anomaly detection status. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="metricId"> metric unique id. </param>
        /// <param name="body"> query options. </param>
        /// <param name="skip"> for paging, skipped number. </param>
        /// <param name="maxpagesize"> the maximum number of items in one page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="body"/> is null. </exception>
        public Response<EnrichmentStatusList> GetEnrichmentStatusByMetricNextPage(string nextLink, Guid metricId, EnrichmentStatusQueryOption body, int? skip = null, int? maxpagesize = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateGetEnrichmentStatusByMetricNextPageRequest(nextLink, metricId, body, skip, maxpagesize);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        EnrichmentStatusList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = EnrichmentStatusList.DeserializeEnrichmentStatusList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
