// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.AI.MetricsAdvisor.Administration;

namespace Azure.AI.MetricsAdvisor.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class MetricsAdvisorModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Administration.DataSourceCredentialEntity"/>. </summary>
        /// <param name="credentialKind"> Type of data source credential. </param>
        /// <param name="id"> Unique id of data source credential. </param>
        /// <param name="name"> Name of data source credential. </param>
        /// <param name="description"> Description of data source credential. </param>
        /// <returns> A new <see cref="Administration.DataSourceCredentialEntity"/> instance for mocking. </returns>
        public static DataSourceCredentialEntity DataSourceCredentialEntity(string credentialKind = null, string id = null, string name = null, string description = null)
        {
            return new UnknownDataSourceCredential(credentialKind == null ? default : new DataSourceCredentialKind(credentialKind), id, name, description);
        }
    }
}
