// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Media.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Media
{
    /// <summary>
    /// A class representing the StreamingPolicy data model.
    /// A Streaming Policy resource
    /// </summary>
    public partial class StreamingPolicyData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StreamingPolicyData"/>. </summary>
        public StreamingPolicyData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="StreamingPolicyData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="createdOn"> Creation time of Streaming Policy. </param>
        /// <param name="defaultContentKeyPolicyName"> Default ContentKey used by current Streaming Policy. </param>
        /// <param name="envelopeEncryption"> Configuration of EnvelopeEncryption. </param>
        /// <param name="commonEncryptionCenc"> Configuration of CommonEncryptionCenc. </param>
        /// <param name="commonEncryptionCbcs"> Configuration of CommonEncryptionCbcs. </param>
        /// <param name="noEncryption"> Configurations of NoEncryption. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StreamingPolicyData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, DateTimeOffset? createdOn, string defaultContentKeyPolicyName, EnvelopeEncryption envelopeEncryption, CommonEncryptionCenc commonEncryptionCenc, CommonEncryptionCbcs commonEncryptionCbcs, NoEncryption noEncryption, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            CreatedOn = createdOn;
            DefaultContentKeyPolicyName = defaultContentKeyPolicyName;
            EnvelopeEncryption = envelopeEncryption;
            CommonEncryptionCenc = commonEncryptionCenc;
            CommonEncryptionCbcs = commonEncryptionCbcs;
            NoEncryption = noEncryption;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Creation time of Streaming Policy. </summary>
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> Default ContentKey used by current Streaming Policy. </summary>
        public string DefaultContentKeyPolicyName { get; set; }
        /// <summary> Configuration of EnvelopeEncryption. </summary>
        public EnvelopeEncryption EnvelopeEncryption { get; set; }
        /// <summary> Configuration of CommonEncryptionCenc. </summary>
        public CommonEncryptionCenc CommonEncryptionCenc { get; set; }
        /// <summary> Configuration of CommonEncryptionCbcs. </summary>
        public CommonEncryptionCbcs CommonEncryptionCbcs { get; set; }
        /// <summary> Configurations of NoEncryption. </summary>
        internal NoEncryption NoEncryption { get; set; }
        /// <summary> Representing supported protocols. </summary>
        public MediaEnabledProtocols NoEncryptionEnabledProtocols
        {
            get => NoEncryption is null ? default : NoEncryption.EnabledProtocols;
            set
            {
                if (NoEncryption is null)
                    NoEncryption = new NoEncryption();
                NoEncryption.EnabledProtocols = value;
            }
        }
    }
}
