// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Media.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Media
{
    /// <summary>
    /// A class representing the StreamingLocator data model.
    /// A Streaming Locator resource
    /// </summary>
    public partial class StreamingLocatorData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StreamingLocatorData"/>. </summary>
        public StreamingLocatorData()
        {
            ContentKeys = new ChangeTrackingList<StreamingLocatorContentKey>();
            Filters = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="StreamingLocatorData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="assetName"> Asset Name. </param>
        /// <param name="createdOn"> The creation time of the Streaming Locator. </param>
        /// <param name="startOn"> The start time of the Streaming Locator. </param>
        /// <param name="endOn"> The end time of the Streaming Locator. </param>
        /// <param name="streamingLocatorId"> The StreamingLocatorId of the Streaming Locator. </param>
        /// <param name="streamingPolicyName"> Name of the Streaming Policy used by this Streaming Locator. Either specify the name of Streaming Policy you created or use one of the predefined Streaming Policies. The predefined Streaming Policies available are: 'Predefined_DownloadOnly', 'Predefined_ClearStreamingOnly', 'Predefined_DownloadAndClearStreaming', 'Predefined_ClearKey', 'Predefined_MultiDrmCencStreaming' and 'Predefined_MultiDrmStreaming'. </param>
        /// <param name="defaultContentKeyPolicyName"> Name of the default ContentKeyPolicy used by this Streaming Locator. </param>
        /// <param name="contentKeys"> The ContentKeys used by this Streaming Locator. </param>
        /// <param name="alternativeMediaId"> Alternative Media ID of this Streaming Locator. </param>
        /// <param name="filters"> A list of asset or account filters which apply to this streaming locator. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StreamingLocatorData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string assetName, DateTimeOffset? createdOn, DateTimeOffset? startOn, DateTimeOffset? endOn, Guid? streamingLocatorId, string streamingPolicyName, string defaultContentKeyPolicyName, IList<StreamingLocatorContentKey> contentKeys, string alternativeMediaId, IList<string> filters, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            AssetName = assetName;
            CreatedOn = createdOn;
            StartOn = startOn;
            EndOn = endOn;
            StreamingLocatorId = streamingLocatorId;
            StreamingPolicyName = streamingPolicyName;
            DefaultContentKeyPolicyName = defaultContentKeyPolicyName;
            ContentKeys = contentKeys;
            AlternativeMediaId = alternativeMediaId;
            Filters = filters;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Asset Name. </summary>
        public string AssetName { get; set; }
        /// <summary> The creation time of the Streaming Locator. </summary>
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> The start time of the Streaming Locator. </summary>
        public DateTimeOffset? StartOn { get; set; }
        /// <summary> The end time of the Streaming Locator. </summary>
        public DateTimeOffset? EndOn { get; set; }
        /// <summary> The StreamingLocatorId of the Streaming Locator. </summary>
        public Guid? StreamingLocatorId { get; set; }
        /// <summary> Name of the Streaming Policy used by this Streaming Locator. Either specify the name of Streaming Policy you created or use one of the predefined Streaming Policies. The predefined Streaming Policies available are: 'Predefined_DownloadOnly', 'Predefined_ClearStreamingOnly', 'Predefined_DownloadAndClearStreaming', 'Predefined_ClearKey', 'Predefined_MultiDrmCencStreaming' and 'Predefined_MultiDrmStreaming'. </summary>
        public string StreamingPolicyName { get; set; }
        /// <summary> Name of the default ContentKeyPolicy used by this Streaming Locator. </summary>
        public string DefaultContentKeyPolicyName { get; set; }
        /// <summary> The ContentKeys used by this Streaming Locator. </summary>
        public IList<StreamingLocatorContentKey> ContentKeys { get; }
        /// <summary> Alternative Media ID of this Streaming Locator. </summary>
        public string AlternativeMediaId { get; set; }
        /// <summary> A list of asset or account filters which apply to this streaming locator. </summary>
        public IList<string> Filters { get; }
    }
}
