// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Media.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Media
{
    /// <summary>
    /// A class representing the StreamingEndpoint data model.
    /// The streaming endpoint.
    /// </summary>
    public partial class StreamingEndpointData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StreamingEndpointData"/>. </summary>
        /// <param name="location"> The location. </param>
        public StreamingEndpointData(AzureLocation location) : base(location)
        {
            CustomHostNames = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="StreamingEndpointData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="sku"> The streaming endpoint sku. </param>
        /// <param name="description"> The streaming endpoint description. </param>
        /// <param name="scaleUnits"> The number of scale units. Use the Scale operation to adjust this value. </param>
        /// <param name="availabilitySetName"> This feature is deprecated, do not set a value for this property. </param>
        /// <param name="accessControl"> The access control definition of the streaming endpoint. </param>
        /// <param name="maxCacheAge"> Max cache age. </param>
        /// <param name="customHostNames"> The custom host names of the streaming endpoint. </param>
        /// <param name="hostName"> The streaming endpoint host name. </param>
        /// <param name="isCdnEnabled"> The CDN enabled flag. </param>
        /// <param name="cdnProvider"> The CDN provider name. </param>
        /// <param name="cdnProfile"> The CDN profile name. </param>
        /// <param name="provisioningState"> The provisioning state of the streaming endpoint. </param>
        /// <param name="resourceState"> The resource state of the streaming endpoint. </param>
        /// <param name="crossSiteAccessPolicies"> The streaming endpoint access policies. </param>
        /// <param name="freeTrialEndOn"> The free trial expiration time. </param>
        /// <param name="createdOn"> The exact time the streaming endpoint was created. </param>
        /// <param name="lastModifiedOn"> The exact time the streaming endpoint was last modified. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StreamingEndpointData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, StreamingEndpointCurrentSku sku, string description, int? scaleUnits, string availabilitySetName, StreamingEndpointAccessControl accessControl, long? maxCacheAge, IList<string> customHostNames, string hostName, bool? isCdnEnabled, string cdnProvider, string cdnProfile, string provisioningState, StreamingEndpointResourceState? resourceState, CrossSiteAccessPolicies crossSiteAccessPolicies, DateTimeOffset? freeTrialEndOn, DateTimeOffset? createdOn, DateTimeOffset? lastModifiedOn, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            Sku = sku;
            Description = description;
            ScaleUnits = scaleUnits;
            AvailabilitySetName = availabilitySetName;
            AccessControl = accessControl;
            MaxCacheAge = maxCacheAge;
            CustomHostNames = customHostNames;
            HostName = hostName;
            IsCdnEnabled = isCdnEnabled;
            CdnProvider = cdnProvider;
            CdnProfile = cdnProfile;
            ProvisioningState = provisioningState;
            ResourceState = resourceState;
            CrossSiteAccessPolicies = crossSiteAccessPolicies;
            FreeTrialEndOn = freeTrialEndOn;
            CreatedOn = createdOn;
            LastModifiedOn = lastModifiedOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="StreamingEndpointData"/> for deserialization. </summary>
        internal StreamingEndpointData()
        {
        }

        /// <summary> The streaming endpoint sku. </summary>
        public StreamingEndpointCurrentSku Sku { get; set; }
        /// <summary> The streaming endpoint description. </summary>
        public string Description { get; set; }
        /// <summary> The number of scale units. Use the Scale operation to adjust this value. </summary>
        public int? ScaleUnits { get; set; }
        /// <summary> This feature is deprecated, do not set a value for this property. </summary>
        public string AvailabilitySetName { get; set; }
        /// <summary> The access control definition of the streaming endpoint. </summary>
        public StreamingEndpointAccessControl AccessControl { get; set; }
        /// <summary> Max cache age. </summary>
        public long? MaxCacheAge { get; set; }
        /// <summary> The custom host names of the streaming endpoint. </summary>
        public IList<string> CustomHostNames { get; }
        /// <summary> The streaming endpoint host name. </summary>
        public string HostName { get; }
        /// <summary> The CDN enabled flag. </summary>
        public bool? IsCdnEnabled { get; set; }
        /// <summary> The CDN provider name. </summary>
        public string CdnProvider { get; set; }
        /// <summary> The CDN profile name. </summary>
        public string CdnProfile { get; set; }
        /// <summary> The provisioning state of the streaming endpoint. </summary>
        public string ProvisioningState { get; }
        /// <summary> The resource state of the streaming endpoint. </summary>
        public StreamingEndpointResourceState? ResourceState { get; }
        /// <summary> The streaming endpoint access policies. </summary>
        public CrossSiteAccessPolicies CrossSiteAccessPolicies { get; set; }
        /// <summary> The free trial expiration time. </summary>
        public DateTimeOffset? FreeTrialEndOn { get; }
        /// <summary> The exact time the streaming endpoint was created. </summary>
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> The exact time the streaming endpoint was last modified. </summary>
        public DateTimeOffset? LastModifiedOn { get; }
    }
}
