// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> The Video Sync Mode. </summary>
    public readonly partial struct VideoSyncMode : IEquatable<VideoSyncMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VideoSyncMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VideoSyncMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AutoValue = "Auto";
        private const string PassthroughValue = "Passthrough";
        private const string CfrValue = "Cfr";
        private const string VfrValue = "Vfr";

        /// <summary> This is the default method. Chooses between Cfr and Vfr depending on muxer capabilities. For output format MP4, the default mode is Cfr. </summary>
        public static VideoSyncMode Auto { get; } = new VideoSyncMode(AutoValue);
        /// <summary> The presentation timestamps on frames are passed through from the input file to the output file writer. Recommended when the input source has variable frame rate, and are attempting to produce multiple layers for adaptive streaming in the output which have aligned GOP boundaries. Note: if two or more frames in the input have duplicate timestamps, then the output will also have the same behavior. </summary>
        public static VideoSyncMode Passthrough { get; } = new VideoSyncMode(PassthroughValue);
        /// <summary> Input frames will be repeated and/or dropped as needed to achieve exactly the requested constant frame rate. Recommended when the output frame rate is explicitly set at a specified value. </summary>
        public static VideoSyncMode Cfr { get; } = new VideoSyncMode(CfrValue);
        /// <summary> Similar to the Passthrough mode, but if the input has frames that have duplicate timestamps, then only one frame is passed through to the output, and others are dropped. Recommended when the number of output frames is expected to be equal to the number of input frames. For example, the output is used to calculate a quality metric like PSNR against the input. </summary>
        public static VideoSyncMode Vfr { get; } = new VideoSyncMode(VfrValue);
        /// <summary> Determines if two <see cref="VideoSyncMode"/> values are the same. </summary>
        public static bool operator ==(VideoSyncMode left, VideoSyncMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VideoSyncMode"/> values are not the same. </summary>
        public static bool operator !=(VideoSyncMode left, VideoSyncMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VideoSyncMode"/>. </summary>
        public static implicit operator VideoSyncMode(string value) => new VideoSyncMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VideoSyncMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VideoSyncMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
