// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> Class to specify one track property condition. </summary>
    public partial class TrackPropertyCondition
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TrackPropertyCondition"/>. </summary>
        /// <param name="property"> Track property type. </param>
        /// <param name="operation"> Track property condition operation. </param>
        public TrackPropertyCondition(TrackPropertyType property, TrackPropertyCompareOperation operation)
        {
            Property = property;
            Operation = operation;
        }

        /// <summary> Initializes a new instance of <see cref="TrackPropertyCondition"/>. </summary>
        /// <param name="property"> Track property type. </param>
        /// <param name="operation"> Track property condition operation. </param>
        /// <param name="value"> Track property value. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TrackPropertyCondition(TrackPropertyType property, TrackPropertyCompareOperation operation, string value, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Property = property;
            Operation = operation;
            Value = value;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="TrackPropertyCondition"/> for deserialization. </summary>
        internal TrackPropertyCondition()
        {
        }

        /// <summary> Track property type. </summary>
        public TrackPropertyType Property { get; set; }
        /// <summary> Track property condition operation. </summary>
        public TrackPropertyCompareOperation Operation { get; set; }
        /// <summary> Track property value. </summary>
        public string Value { get; set; }
    }
}
