// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> Track property condition operation. </summary>
    public readonly partial struct TrackPropertyCompareOperation : IEquatable<TrackPropertyCompareOperation>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TrackPropertyCompareOperation"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TrackPropertyCompareOperation(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string EqualValue = "Equal";

        /// <summary> Unknown track property compare operation. </summary>
        public static TrackPropertyCompareOperation Unknown { get; } = new TrackPropertyCompareOperation(UnknownValue);
        /// <summary> Equal operation. </summary>
        public static TrackPropertyCompareOperation Equal { get; } = new TrackPropertyCompareOperation(EqualValue);
        /// <summary> Determines if two <see cref="TrackPropertyCompareOperation"/> values are the same. </summary>
        public static bool operator ==(TrackPropertyCompareOperation left, TrackPropertyCompareOperation right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TrackPropertyCompareOperation"/> values are not the same. </summary>
        public static bool operator !=(TrackPropertyCompareOperation left, TrackPropertyCompareOperation right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TrackPropertyCompareOperation"/>. </summary>
        public static implicit operator TrackPropertyCompareOperation(string value) => new TrackPropertyCompareOperation(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TrackPropertyCompareOperation other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TrackPropertyCompareOperation other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
