// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks. </summary>
    public readonly partial struct TrackAttributeFilter : IEquatable<TrackAttributeFilter>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TrackAttributeFilter"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TrackAttributeFilter(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllValue = "All";
        private const string TopValue = "Top";
        private const string BottomValue = "Bottom";
        private const string ValueEqualsValue = "ValueEquals";

        /// <summary> All tracks will be included. </summary>
        public static TrackAttributeFilter All { get; } = new TrackAttributeFilter(AllValue);
        /// <summary> The first track will be included when the attribute is sorted in descending order.  Generally used to select the largest bitrate. </summary>
        public static TrackAttributeFilter Top { get; } = new TrackAttributeFilter(TopValue);
        /// <summary> The first track will be included when the attribute is sorted in ascending order.  Generally used to select the smallest bitrate. </summary>
        public static TrackAttributeFilter Bottom { get; } = new TrackAttributeFilter(BottomValue);
        /// <summary> Any tracks that have an attribute equal to the value given will be included. </summary>
        public static TrackAttributeFilter ValueEquals { get; } = new TrackAttributeFilter(ValueEqualsValue);
        /// <summary> Determines if two <see cref="TrackAttributeFilter"/> values are the same. </summary>
        public static bool operator ==(TrackAttributeFilter left, TrackAttributeFilter right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TrackAttributeFilter"/> values are not the same. </summary>
        public static bool operator !=(TrackAttributeFilter left, TrackAttributeFilter right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TrackAttributeFilter"/>. </summary>
        public static implicit operator TrackAttributeFilter(string value) => new TrackAttributeFilter(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TrackAttributeFilter other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TrackAttributeFilter other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
