// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> The TrackAttribute to filter the tracks by. </summary>
    public readonly partial struct TrackAttribute : IEquatable<TrackAttribute>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TrackAttribute"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TrackAttribute(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BitrateValue = "Bitrate";
        private const string LanguageValue = "Language";

        /// <summary> The bitrate of the track. </summary>
        public static TrackAttribute Bitrate { get; } = new TrackAttribute(BitrateValue);
        /// <summary> The language of the track. </summary>
        public static TrackAttribute Language { get; } = new TrackAttribute(LanguageValue);
        /// <summary> Determines if two <see cref="TrackAttribute"/> values are the same. </summary>
        public static bool operator ==(TrackAttribute left, TrackAttribute right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TrackAttribute"/> values are not the same. </summary>
        public static bool operator !=(TrackAttribute left, TrackAttribute right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TrackAttribute"/>. </summary>
        public static implicit operator TrackAttribute(string value) => new TrackAttribute(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TrackAttribute other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TrackAttribute other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
