// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> Streaming protocol. </summary>
    public readonly partial struct StreamingPolicyStreamingProtocol : IEquatable<StreamingPolicyStreamingProtocol>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StreamingPolicyStreamingProtocol"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StreamingPolicyStreamingProtocol(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HlsValue = "Hls";
        private const string DashValue = "Dash";
        private const string SmoothStreamingValue = "SmoothStreaming";
        private const string DownloadValue = "Download";

        /// <summary> HLS protocol. </summary>
        public static StreamingPolicyStreamingProtocol Hls { get; } = new StreamingPolicyStreamingProtocol(HlsValue);
        /// <summary> DASH protocol. </summary>
        public static StreamingPolicyStreamingProtocol Dash { get; } = new StreamingPolicyStreamingProtocol(DashValue);
        /// <summary> SmoothStreaming protocol. </summary>
        public static StreamingPolicyStreamingProtocol SmoothStreaming { get; } = new StreamingPolicyStreamingProtocol(SmoothStreamingValue);
        /// <summary> Download protocol. </summary>
        public static StreamingPolicyStreamingProtocol Download { get; } = new StreamingPolicyStreamingProtocol(DownloadValue);
        /// <summary> Determines if two <see cref="StreamingPolicyStreamingProtocol"/> values are the same. </summary>
        public static bool operator ==(StreamingPolicyStreamingProtocol left, StreamingPolicyStreamingProtocol right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StreamingPolicyStreamingProtocol"/> values are not the same. </summary>
        public static bool operator !=(StreamingPolicyStreamingProtocol left, StreamingPolicyStreamingProtocol right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StreamingPolicyStreamingProtocol"/>. </summary>
        public static implicit operator StreamingPolicyStreamingProtocol(string value) => new StreamingPolicyStreamingProtocol(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StreamingPolicyStreamingProtocol other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StreamingPolicyStreamingProtocol other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
