// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> Encryption scheme. </summary>
    public readonly partial struct StreamingPathEncryptionScheme : IEquatable<StreamingPathEncryptionScheme>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StreamingPathEncryptionScheme"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StreamingPathEncryptionScheme(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoEncryptionValue = "NoEncryption";
        private const string EnvelopeEncryptionValue = "EnvelopeEncryption";
        private const string CommonEncryptionCencValue = "CommonEncryptionCenc";
        private const string CommonEncryptionCbcsValue = "CommonEncryptionCbcs";

        /// <summary> NoEncryption scheme. </summary>
        public static StreamingPathEncryptionScheme NoEncryption { get; } = new StreamingPathEncryptionScheme(NoEncryptionValue);
        /// <summary> EnvelopeEncryption scheme. </summary>
        public static StreamingPathEncryptionScheme EnvelopeEncryption { get; } = new StreamingPathEncryptionScheme(EnvelopeEncryptionValue);
        /// <summary> CommonEncryptionCenc scheme. </summary>
        public static StreamingPathEncryptionScheme CommonEncryptionCenc { get; } = new StreamingPathEncryptionScheme(CommonEncryptionCencValue);
        /// <summary> CommonEncryptionCbcs scheme. </summary>
        public static StreamingPathEncryptionScheme CommonEncryptionCbcs { get; } = new StreamingPathEncryptionScheme(CommonEncryptionCbcsValue);
        /// <summary> Determines if two <see cref="StreamingPathEncryptionScheme"/> values are the same. </summary>
        public static bool operator ==(StreamingPathEncryptionScheme left, StreamingPathEncryptionScheme right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StreamingPathEncryptionScheme"/> values are not the same. </summary>
        public static bool operator !=(StreamingPathEncryptionScheme left, StreamingPathEncryptionScheme right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StreamingPathEncryptionScheme"/>. </summary>
        public static implicit operator StreamingPathEncryptionScheme(string value) => new StreamingPathEncryptionScheme(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StreamingPathEncryptionScheme other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StreamingPathEncryptionScheme other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
