// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> Class of paths for streaming. </summary>
    public partial class StreamingPath
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StreamingPath"/>. </summary>
        /// <param name="streamingProtocol"> Streaming protocol. </param>
        /// <param name="encryptionScheme"> Encryption scheme. </param>
        internal StreamingPath(StreamingPolicyStreamingProtocol streamingProtocol, StreamingPathEncryptionScheme encryptionScheme)
        {
            StreamingProtocol = streamingProtocol;
            EncryptionScheme = encryptionScheme;
            Paths = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="StreamingPath"/>. </summary>
        /// <param name="streamingProtocol"> Streaming protocol. </param>
        /// <param name="encryptionScheme"> Encryption scheme. </param>
        /// <param name="paths"> Streaming paths for each protocol and encryptionScheme pair. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StreamingPath(StreamingPolicyStreamingProtocol streamingProtocol, StreamingPathEncryptionScheme encryptionScheme, IReadOnlyList<string> paths, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            StreamingProtocol = streamingProtocol;
            EncryptionScheme = encryptionScheme;
            Paths = paths;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="StreamingPath"/> for deserialization. </summary>
        internal StreamingPath()
        {
        }

        /// <summary> Streaming protocol. </summary>
        public StreamingPolicyStreamingProtocol StreamingProtocol { get; }
        /// <summary> Encryption scheme. </summary>
        public StreamingPathEncryptionScheme EncryptionScheme { get; }
        /// <summary> Streaming paths for each protocol and encryptionScheme pair. </summary>
        public IReadOnlyList<string> Paths { get; }
    }
}
