// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> Encryption type of Content Key. </summary>
    public readonly partial struct StreamingLocatorContentKeyType : IEquatable<StreamingLocatorContentKeyType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StreamingLocatorContentKeyType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StreamingLocatorContentKeyType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CommonEncryptionCencValue = "CommonEncryptionCenc";
        private const string CommonEncryptionCbcsValue = "CommonEncryptionCbcs";
        private const string EnvelopeEncryptionValue = "EnvelopeEncryption";

        /// <summary> Common Encryption using CENC. </summary>
        public static StreamingLocatorContentKeyType CommonEncryptionCenc { get; } = new StreamingLocatorContentKeyType(CommonEncryptionCencValue);
        /// <summary> Common Encryption using CBCS. </summary>
        public static StreamingLocatorContentKeyType CommonEncryptionCbcs { get; } = new StreamingLocatorContentKeyType(CommonEncryptionCbcsValue);
        /// <summary> Envelope Encryption. </summary>
        public static StreamingLocatorContentKeyType EnvelopeEncryption { get; } = new StreamingLocatorContentKeyType(EnvelopeEncryptionValue);
        /// <summary> Determines if two <see cref="StreamingLocatorContentKeyType"/> values are the same. </summary>
        public static bool operator ==(StreamingLocatorContentKeyType left, StreamingLocatorContentKeyType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StreamingLocatorContentKeyType"/> values are not the same. </summary>
        public static bool operator !=(StreamingLocatorContentKeyType left, StreamingLocatorContentKeyType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StreamingLocatorContentKeyType"/>. </summary>
        public static implicit operator StreamingLocatorContentKeyType(string value) => new StreamingLocatorContentKeyType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StreamingLocatorContentKeyType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StreamingLocatorContentKeyType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
