// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> The resource state of the streaming endpoint. </summary>
    public readonly partial struct StreamingEndpointResourceState : IEquatable<StreamingEndpointResourceState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StreamingEndpointResourceState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StreamingEndpointResourceState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StoppedValue = "Stopped";
        private const string StartingValue = "Starting";
        private const string RunningValue = "Running";
        private const string StoppingValue = "Stopping";
        private const string DeletingValue = "Deleting";
        private const string ScalingValue = "Scaling";

        /// <summary> The initial state of a streaming endpoint after creation. Content is not ready to be streamed from this endpoint. </summary>
        public static StreamingEndpointResourceState Stopped { get; } = new StreamingEndpointResourceState(StoppedValue);
        /// <summary> The streaming endpoint is transitioning to the running state. </summary>
        public static StreamingEndpointResourceState Starting { get; } = new StreamingEndpointResourceState(StartingValue);
        /// <summary> The streaming endpoint is running. It is able to stream content to clients. </summary>
        public static StreamingEndpointResourceState Running { get; } = new StreamingEndpointResourceState(RunningValue);
        /// <summary> The streaming endpoint is transitioning to the stopped state. </summary>
        public static StreamingEndpointResourceState Stopping { get; } = new StreamingEndpointResourceState(StoppingValue);
        /// <summary> The streaming endpoint is being deleted. </summary>
        public static StreamingEndpointResourceState Deleting { get; } = new StreamingEndpointResourceState(DeletingValue);
        /// <summary> The streaming endpoint is increasing or decreasing scale units. </summary>
        public static StreamingEndpointResourceState Scaling { get; } = new StreamingEndpointResourceState(ScalingValue);
        /// <summary> Determines if two <see cref="StreamingEndpointResourceState"/> values are the same. </summary>
        public static bool operator ==(StreamingEndpointResourceState left, StreamingEndpointResourceState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StreamingEndpointResourceState"/> values are not the same. </summary>
        public static bool operator !=(StreamingEndpointResourceState left, StreamingEndpointResourceState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StreamingEndpointResourceState"/>. </summary>
        public static implicit operator StreamingEndpointResourceState(string value) => new StreamingEndpointResourceState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StreamingEndpointResourceState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StreamingEndpointResourceState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
