// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> Streaming endpoint access control definition. </summary>
    public partial class StreamingEndpointAccessControl
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StreamingEndpointAccessControl"/>. </summary>
        public StreamingEndpointAccessControl()
        {
        }

        /// <summary> Initializes a new instance of <see cref="StreamingEndpointAccessControl"/>. </summary>
        /// <param name="akamai"> The access control of Akamai. </param>
        /// <param name="iPs"> The IP access control of the streaming endpoint. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StreamingEndpointAccessControl(AkamaiAccessControl akamai, IPAccessControl iPs, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Akamai = akamai;
            IPs = iPs;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The access control of Akamai. </summary>
        internal AkamaiAccessControl Akamai { get; set; }
        /// <summary> authentication key list. </summary>
        public IList<AkamaiSignatureHeaderAuthenticationKey> AkamaiSignatureHeaderAuthenticationKeyList
        {
            get
            {
                if (Akamai is null)
                    Akamai = new AkamaiAccessControl();
                return Akamai.AkamaiSignatureHeaderAuthenticationKeyList;
            }
        }

        /// <summary> The IP access control of the streaming endpoint. </summary>
        internal IPAccessControl IPs { get; set; }
        /// <summary> The IP allow list. </summary>
        public IList<IPRange> AllowedIPs
        {
            get
            {
                if (IPs is null)
                    IPs = new IPAccessControl();
                return IPs.AllowedIPs;
            }
        }
    }
}
