// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> The StreamOptionsFlag. </summary>
    public readonly partial struct StreamOptionsFlag : IEquatable<StreamOptionsFlag>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StreamOptionsFlag"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StreamOptionsFlag(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "Default";
        private const string LowLatencyValue = "LowLatency";
        private const string LowLatencyV2Value = "LowLatencyV2";

        /// <summary> Live streaming with no special latency optimizations. </summary>
        public static StreamOptionsFlag Default { get; } = new StreamOptionsFlag(DefaultValue);
        /// <summary> The live event provides lower end to end latency by reducing its internal buffers. </summary>
        public static StreamOptionsFlag LowLatency { get; } = new StreamOptionsFlag(LowLatencyValue);
        /// <summary> The live event is optimized for end to end latency. This option is only available for encoding live events with RTMP input. The outputs can be streamed using HLS or DASH formats. The outputs' archive or DVR rewind length is limited to 6 hours. Use "LowLatency" stream option for all other scenarios. </summary>
        public static StreamOptionsFlag LowLatencyV2 { get; } = new StreamOptionsFlag(LowLatencyV2Value);
        /// <summary> Determines if two <see cref="StreamOptionsFlag"/> values are the same. </summary>
        public static bool operator ==(StreamOptionsFlag left, StreamOptionsFlag right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StreamOptionsFlag"/> values are not the same. </summary>
        public static bool operator !=(StreamOptionsFlag left, StreamOptionsFlag right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StreamOptionsFlag"/>. </summary>
        public static implicit operator StreamOptionsFlag(string value) => new StreamOptionsFlag(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StreamOptionsFlag other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StreamOptionsFlag other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
