// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> Data needed to decrypt asset files encrypted with legacy storage encryption. </summary>
    public partial class StorageEncryptedAssetDecryptionInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StorageEncryptedAssetDecryptionInfo"/>. </summary>
        internal StorageEncryptedAssetDecryptionInfo()
        {
            AssetFileEncryptionMetadata = new ChangeTrackingList<MediaAssetFileEncryptionMetadata>();
        }

        /// <summary> Initializes a new instance of <see cref="StorageEncryptedAssetDecryptionInfo"/>. </summary>
        /// <param name="key"> The Asset File storage encryption key. </param>
        /// <param name="assetFileEncryptionMetadata"> Asset File encryption metadata. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StorageEncryptedAssetDecryptionInfo(byte[] key, IReadOnlyList<MediaAssetFileEncryptionMetadata> assetFileEncryptionMetadata, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Key = key;
            AssetFileEncryptionMetadata = assetFileEncryptionMetadata;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Asset File storage encryption key. </summary>
        public byte[] Key { get; }
        /// <summary> Asset File encryption metadata. </summary>
        public IReadOnlyList<MediaAssetFileEncryptionMetadata> AssetFileEncryptionMetadata { get; }
    }
}
