// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Media.Models
{
    public partial class SelectVideoTrackByAttribute : IUtf8JsonSerializable, IJsonModel<SelectVideoTrackByAttribute>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SelectVideoTrackByAttribute>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SelectVideoTrackByAttribute>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SelectVideoTrackByAttribute>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SelectVideoTrackByAttribute)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("attribute"u8);
            writer.WriteStringValue(Attribute.ToString());
            writer.WritePropertyName("filter"u8);
            writer.WriteStringValue(Filter.ToString());
            if (Optional.IsDefined(FilterValue))
            {
                writer.WritePropertyName("filterValue"u8);
                writer.WriteStringValue(FilterValue);
            }
        }

        SelectVideoTrackByAttribute IJsonModel<SelectVideoTrackByAttribute>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SelectVideoTrackByAttribute>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SelectVideoTrackByAttribute)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSelectVideoTrackByAttribute(document.RootElement, options);
        }

        internal static SelectVideoTrackByAttribute DeserializeSelectVideoTrackByAttribute(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            TrackAttribute attribute = default;
            TrackAttributeFilter filter = default;
            string filterValue = default;
            string odataType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("attribute"u8))
                {
                    attribute = new TrackAttribute(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("filter"u8))
                {
                    filter = new TrackAttributeFilter(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("filterValue"u8))
                {
                    filterValue = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("@odata.type"u8))
                {
                    odataType = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SelectVideoTrackByAttribute(odataType, serializedAdditionalRawData, attribute, filter, filterValue);
        }

        BinaryData IPersistableModel<SelectVideoTrackByAttribute>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SelectVideoTrackByAttribute>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SelectVideoTrackByAttribute)} does not support writing '{options.Format}' format.");
            }
        }

        SelectVideoTrackByAttribute IPersistableModel<SelectVideoTrackByAttribute>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SelectVideoTrackByAttribute>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSelectVideoTrackByAttribute(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SelectVideoTrackByAttribute)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SelectVideoTrackByAttribute>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
