// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Media.Models
{
    public partial class SelectAudioTrackById : IUtf8JsonSerializable, IJsonModel<SelectAudioTrackById>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SelectAudioTrackById>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SelectAudioTrackById>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SelectAudioTrackById>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SelectAudioTrackById)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("trackId"u8);
            writer.WriteNumberValue(TrackId);
        }

        SelectAudioTrackById IJsonModel<SelectAudioTrackById>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SelectAudioTrackById>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SelectAudioTrackById)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSelectAudioTrackById(document.RootElement, options);
        }

        internal static SelectAudioTrackById DeserializeSelectAudioTrackById(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            long trackId = default;
            ChannelMapping? channelMapping = default;
            string odataType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("trackId"u8))
                {
                    trackId = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("channelMapping"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    channelMapping = new ChannelMapping(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("@odata.type"u8))
                {
                    odataType = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SelectAudioTrackById(odataType, serializedAdditionalRawData, channelMapping, trackId);
        }

        BinaryData IPersistableModel<SelectAudioTrackById>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SelectAudioTrackById>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SelectAudioTrackById)} does not support writing '{options.Format}' format.");
            }
        }

        SelectAudioTrackById IPersistableModel<SelectAudioTrackById>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SelectAudioTrackById>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSelectAudioTrackById(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SelectAudioTrackById)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SelectAudioTrackById>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
