// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> Select audio tracks from the input by specifying an attribute and an attribute filter. </summary>
    public partial class SelectAudioTrackByAttribute : AudioTrackDescriptor
    {
        /// <summary> Initializes a new instance of <see cref="SelectAudioTrackByAttribute"/>. </summary>
        /// <param name="attribute"> The TrackAttribute to filter the tracks by. </param>
        /// <param name="filter"> The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks. </param>
        public SelectAudioTrackByAttribute(TrackAttribute attribute, TrackAttributeFilter filter)
        {
            Attribute = attribute;
            Filter = filter;
            OdataType = "#Microsoft.Media.SelectAudioTrackByAttribute";
        }

        /// <summary> Initializes a new instance of <see cref="SelectAudioTrackByAttribute"/>. </summary>
        /// <param name="odataType"> The discriminator for derived types. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="channelMapping"> Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks. </param>
        /// <param name="attribute"> The TrackAttribute to filter the tracks by. </param>
        /// <param name="filter"> The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks. </param>
        /// <param name="filterValue"> The value to filter the tracks by.  Only used when AttributeFilter.ValueEquals is specified for the Filter property. </param>
        internal SelectAudioTrackByAttribute(string odataType, IDictionary<string, BinaryData> serializedAdditionalRawData, ChannelMapping? channelMapping, TrackAttribute attribute, TrackAttributeFilter filter, string filterValue) : base(odataType, serializedAdditionalRawData, channelMapping)
        {
            Attribute = attribute;
            Filter = filter;
            FilterValue = filterValue;
            OdataType = odataType ?? "#Microsoft.Media.SelectAudioTrackByAttribute";
        }

        /// <summary> Initializes a new instance of <see cref="SelectAudioTrackByAttribute"/> for deserialization. </summary>
        internal SelectAudioTrackByAttribute()
        {
        }

        /// <summary> The TrackAttribute to filter the tracks by. </summary>
        public TrackAttribute Attribute { get; set; }
        /// <summary> The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks. </summary>
        public TrackAttributeFilter Filter { get; set; }
        /// <summary> The value to filter the tracks by.  Only used when AttributeFilter.ValueEquals is specified for the Filter property. </summary>
        public string FilterValue { get; set; }
    }
}
