// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> The ResourceIdentity. </summary>
    public partial class ResourceIdentity
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ResourceIdentity"/>. </summary>
        /// <param name="useSystemAssignedIdentity"> Indicates whether to use System Assigned Managed Identity. Mutual exclusive with User Assigned Managed Identity. </param>
        public ResourceIdentity(bool useSystemAssignedIdentity)
        {
            UseSystemAssignedIdentity = useSystemAssignedIdentity;
        }

        /// <summary> Initializes a new instance of <see cref="ResourceIdentity"/>. </summary>
        /// <param name="userAssignedIdentity"> The user assigned managed identity's ARM ID to use when accessing a resource. </param>
        /// <param name="useSystemAssignedIdentity"> Indicates whether to use System Assigned Managed Identity. Mutual exclusive with User Assigned Managed Identity. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResourceIdentity(string userAssignedIdentity, bool useSystemAssignedIdentity, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            UserAssignedIdentity = userAssignedIdentity;
            UseSystemAssignedIdentity = useSystemAssignedIdentity;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ResourceIdentity"/> for deserialization. </summary>
        internal ResourceIdentity()
        {
        }

        /// <summary> The user assigned managed identity's ARM ID to use when accessing a resource. </summary>
        public string UserAssignedIdentity { get; set; }
        /// <summary> Indicates whether to use System Assigned Managed Identity. Mutual exclusive with User Assigned Managed Identity. </summary>
        public bool UseSystemAssignedIdentity { get; set; }
    }
}
