// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Media.Models
{
    public partial class PresentationTimeRange : IUtf8JsonSerializable, IJsonModel<PresentationTimeRange>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<PresentationTimeRange>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<PresentationTimeRange>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PresentationTimeRange>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PresentationTimeRange)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(StartTimestamp))
            {
                writer.WritePropertyName("startTimestamp"u8);
                writer.WriteNumberValue(StartTimestamp.Value);
            }
            if (Optional.IsDefined(EndTimestamp))
            {
                writer.WritePropertyName("endTimestamp"u8);
                writer.WriteNumberValue(EndTimestamp.Value);
            }
            if (Optional.IsDefined(PresentationWindowDuration))
            {
                writer.WritePropertyName("presentationWindowDuration"u8);
                writer.WriteNumberValue(PresentationWindowDuration.Value);
            }
            if (Optional.IsDefined(LiveBackoffDuration))
            {
                writer.WritePropertyName("liveBackoffDuration"u8);
                writer.WriteNumberValue(LiveBackoffDuration.Value);
            }
            if (Optional.IsDefined(Timescale))
            {
                writer.WritePropertyName("timescale"u8);
                writer.WriteNumberValue(Timescale.Value);
            }
            if (Optional.IsDefined(ForceEndTimestamp))
            {
                writer.WritePropertyName("forceEndTimestamp"u8);
                writer.WriteBooleanValue(ForceEndTimestamp.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        PresentationTimeRange IJsonModel<PresentationTimeRange>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PresentationTimeRange>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PresentationTimeRange)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializePresentationTimeRange(document.RootElement, options);
        }

        internal static PresentationTimeRange DeserializePresentationTimeRange(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            long? startTimestamp = default;
            long? endTimestamp = default;
            long? presentationWindowDuration = default;
            long? liveBackoffDuration = default;
            long? timescale = default;
            bool? forceEndTimestamp = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("startTimestamp"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    startTimestamp = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("endTimestamp"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    endTimestamp = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("presentationWindowDuration"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    presentationWindowDuration = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("liveBackoffDuration"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    liveBackoffDuration = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("timescale"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    timescale = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("forceEndTimestamp"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    forceEndTimestamp = property.Value.GetBoolean();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new PresentationTimeRange(
                startTimestamp,
                endTimestamp,
                presentationWindowDuration,
                liveBackoffDuration,
                timescale,
                forceEndTimestamp,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<PresentationTimeRange>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PresentationTimeRange>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(PresentationTimeRange)} does not support writing '{options.Format}' format.");
            }
        }

        PresentationTimeRange IPersistableModel<PresentationTimeRange>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PresentationTimeRange>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializePresentationTimeRange(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(PresentationTimeRange)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<PresentationTimeRange>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
