// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> When PlayerVisibility is set to "Visible", the text track will be present in the DASH manifest or HLS playlist when requested by a client. When the PlayerVisibility is set to "Hidden", the text will not be available to the client. The default value is "Visible". </summary>
    public readonly partial struct PlayerVisibility : IEquatable<PlayerVisibility>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PlayerVisibility"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PlayerVisibility(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HiddenValue = "Hidden";
        private const string VisibleValue = "Visible";

        /// <summary> The track is hidden to video player. </summary>
        public static PlayerVisibility Hidden { get; } = new PlayerVisibility(HiddenValue);
        /// <summary> The track is visible to video player. </summary>
        public static PlayerVisibility Visible { get; } = new PlayerVisibility(VisibleValue);
        /// <summary> Determines if two <see cref="PlayerVisibility"/> values are the same. </summary>
        public static bool operator ==(PlayerVisibility left, PlayerVisibility right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PlayerVisibility"/> values are not the same. </summary>
        public static bool operator !=(PlayerVisibility left, PlayerVisibility right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PlayerVisibility"/>. </summary>
        public static implicit operator PlayerVisibility(string value) => new PlayerVisibility(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PlayerVisibility other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PlayerVisibility other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
