// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> The security level. </summary>
    public readonly partial struct PlayReadySecurityLevel : IEquatable<PlayReadySecurityLevel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PlayReadySecurityLevel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PlayReadySecurityLevel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string SL150Value = "SL150";
        private const string SL2000Value = "SL2000";
        private const string SL3000Value = "SL3000";

        /// <summary> Represents a SecurityLevel that is unavailable in current API version. </summary>
        public static PlayReadySecurityLevel Unknown { get; } = new PlayReadySecurityLevel(UnknownValue);
        /// <summary> For clients under development or test. No protection against unauthorized use. </summary>
        public static PlayReadySecurityLevel SL150 { get; } = new PlayReadySecurityLevel(SL150Value);
        /// <summary> For hardened devices and applications consuming commercial content. Software or hardware protection. </summary>
        public static PlayReadySecurityLevel SL2000 { get; } = new PlayReadySecurityLevel(SL2000Value);
        /// <summary> For hardened devices only. Hardware protection. </summary>
        public static PlayReadySecurityLevel SL3000 { get; } = new PlayReadySecurityLevel(SL3000Value);
        /// <summary> Determines if two <see cref="PlayReadySecurityLevel"/> values are the same. </summary>
        public static bool operator ==(PlayReadySecurityLevel left, PlayReadySecurityLevel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PlayReadySecurityLevel"/> values are not the same. </summary>
        public static bool operator !=(PlayReadySecurityLevel left, PlayReadySecurityLevel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PlayReadySecurityLevel"/>. </summary>
        public static implicit operator PlayReadySecurityLevel(string value) => new PlayReadySecurityLevel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PlayReadySecurityLevel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PlayReadySecurityLevel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
