// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> A Transform can define more than one outputs. This property defines what the service should do when one output fails - either continue to produce other outputs, or, stop the other outputs. The overall Job state will not reflect failures of outputs that are specified with 'ContinueJob'. The default is 'StopProcessingJob'. </summary>
    public readonly partial struct MediaTransformOnErrorType : IEquatable<MediaTransformOnErrorType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MediaTransformOnErrorType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MediaTransformOnErrorType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StopProcessingJobValue = "StopProcessingJob";
        private const string ContinueJobValue = "ContinueJob";

        /// <summary> Tells the service that if this TransformOutput fails, then any other incomplete TransformOutputs can be stopped. </summary>
        public static MediaTransformOnErrorType StopProcessingJob { get; } = new MediaTransformOnErrorType(StopProcessingJobValue);
        /// <summary> Tells the service that if this TransformOutput fails, then allow any other TransformOutput to continue. </summary>
        public static MediaTransformOnErrorType ContinueJob { get; } = new MediaTransformOnErrorType(ContinueJobValue);
        /// <summary> Determines if two <see cref="MediaTransformOnErrorType"/> values are the same. </summary>
        public static bool operator ==(MediaTransformOnErrorType left, MediaTransformOnErrorType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MediaTransformOnErrorType"/> values are not the same. </summary>
        public static bool operator !=(MediaTransformOnErrorType left, MediaTransformOnErrorType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MediaTransformOnErrorType"/>. </summary>
        public static implicit operator MediaTransformOnErrorType(string value) => new MediaTransformOnErrorType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MediaTransformOnErrorType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MediaTransformOnErrorType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
