// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> Class to select a track. </summary>
    public partial class MediaTrackSelection
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MediaTrackSelection"/>. </summary>
        public MediaTrackSelection()
        {
            TrackSelections = new ChangeTrackingList<TrackPropertyCondition>();
        }

        /// <summary> Initializes a new instance of <see cref="MediaTrackSelection"/>. </summary>
        /// <param name="trackSelections"> TrackSelections is a track property condition list which can specify track(s). </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MediaTrackSelection(IList<TrackPropertyCondition> trackSelections, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TrackSelections = trackSelections;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> TrackSelections is a track property condition list which can specify track(s). </summary>
        public IList<TrackPropertyCondition> TrackSelections { get; }
    }
}
