// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> The MediaStorageAuthentication. </summary>
    public readonly partial struct MediaStorageAuthentication : IEquatable<MediaStorageAuthentication>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MediaStorageAuthentication"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MediaStorageAuthentication(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SystemValue = "System";
        private const string ManagedIdentityValue = "ManagedIdentity";

        /// <summary> System authentication. </summary>
        public static MediaStorageAuthentication System { get; } = new MediaStorageAuthentication(SystemValue);
        /// <summary> Managed Identity authentication. </summary>
        public static MediaStorageAuthentication ManagedIdentity { get; } = new MediaStorageAuthentication(ManagedIdentityValue);
        /// <summary> Determines if two <see cref="MediaStorageAuthentication"/> values are the same. </summary>
        public static bool operator ==(MediaStorageAuthentication left, MediaStorageAuthentication right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MediaStorageAuthentication"/> values are not the same. </summary>
        public static bool operator !=(MediaStorageAuthentication left, MediaStorageAuthentication right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MediaStorageAuthentication"/>. </summary>
        public static implicit operator MediaStorageAuthentication(string value) => new MediaStorageAuthentication(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MediaStorageAuthentication other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MediaStorageAuthentication other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
