// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> The type of the storage account. </summary>
    public readonly partial struct MediaServicesStorageAccountType : IEquatable<MediaServicesStorageAccountType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MediaServicesStorageAccountType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MediaServicesStorageAccountType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PrimaryValue = "Primary";
        private const string SecondaryValue = "Secondary";

        /// <summary> The primary storage account for the Media Services account. </summary>
        public static MediaServicesStorageAccountType Primary { get; } = new MediaServicesStorageAccountType(PrimaryValue);
        /// <summary> A secondary storage account for the Media Services account. </summary>
        public static MediaServicesStorageAccountType Secondary { get; } = new MediaServicesStorageAccountType(SecondaryValue);
        /// <summary> Determines if two <see cref="MediaServicesStorageAccountType"/> values are the same. </summary>
        public static bool operator ==(MediaServicesStorageAccountType left, MediaServicesStorageAccountType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MediaServicesStorageAccountType"/> values are not the same. </summary>
        public static bool operator !=(MediaServicesStorageAccountType left, MediaServicesStorageAccountType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MediaServicesStorageAccountType"/>. </summary>
        public static implicit operator MediaServicesStorageAccountType(string value) => new MediaServicesStorageAccountType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MediaServicesStorageAccountType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MediaServicesStorageAccountType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
