// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> The storage account details. </summary>
    public partial class MediaServicesStorageAccount
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MediaServicesStorageAccount"/>. </summary>
        /// <param name="accountType"> The type of the storage account. </param>
        public MediaServicesStorageAccount(MediaServicesStorageAccountType accountType)
        {
            AccountType = accountType;
        }

        /// <summary> Initializes a new instance of <see cref="MediaServicesStorageAccount"/>. </summary>
        /// <param name="id"> The ID of the storage account resource. Media Services relies on tables and queues as well as blobs, so the primary storage account must be a Standard Storage account (either Microsoft.ClassicStorage or Microsoft.Storage). Blob only storage accounts can be added as secondary storage accounts. </param>
        /// <param name="accountType"> The type of the storage account. </param>
        /// <param name="identity"> The storage account identity. </param>
        /// <param name="status"> The current status of the storage account mapping. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MediaServicesStorageAccount(ResourceIdentifier id, MediaServicesStorageAccountType accountType, ResourceIdentity identity, string status, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            AccountType = accountType;
            Identity = identity;
            Status = status;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MediaServicesStorageAccount"/> for deserialization. </summary>
        internal MediaServicesStorageAccount()
        {
        }

        /// <summary> The ID of the storage account resource. Media Services relies on tables and queues as well as blobs, so the primary storage account must be a Standard Storage account (either Microsoft.ClassicStorage or Microsoft.Storage). Blob only storage accounts can be added as secondary storage accounts. </summary>
        public ResourceIdentifier Id { get; set; }
        /// <summary> The type of the storage account. </summary>
        public MediaServicesStorageAccountType AccountType { get; set; }
        /// <summary> The storage account identity. </summary>
        public ResourceIdentity Identity { get; set; }
        /// <summary> The current status of the storage account mapping. </summary>
        public string Status { get; }
    }
}
