// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> Provisioning state of the Media Services account. </summary>
    public readonly partial struct MediaServicesProvisioningState : IEquatable<MediaServicesProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MediaServicesProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MediaServicesProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FailedValue = "Failed";
        private const string InProgressValue = "InProgress";
        private const string SucceededValue = "Succeeded";

        /// <summary> Provisioning state failed. </summary>
        public static MediaServicesProvisioningState Failed { get; } = new MediaServicesProvisioningState(FailedValue);
        /// <summary> Provisioning state in progress. </summary>
        public static MediaServicesProvisioningState InProgress { get; } = new MediaServicesProvisioningState(InProgressValue);
        /// <summary> Provisioning state succeeded. </summary>
        public static MediaServicesProvisioningState Succeeded { get; } = new MediaServicesProvisioningState(SucceededValue);
        /// <summary> Determines if two <see cref="MediaServicesProvisioningState"/> values are the same. </summary>
        public static bool operator ==(MediaServicesProvisioningState left, MediaServicesProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MediaServicesProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(MediaServicesProvisioningState left, MediaServicesProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MediaServicesProvisioningState"/>. </summary>
        public static implicit operator MediaServicesProvisioningState(string value) => new MediaServicesProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MediaServicesProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MediaServicesProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
