// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> The minimum TLS version allowed for this account's requests. This is an optional property. If unspecified, a secure default value will be used. </summary>
    public readonly partial struct MediaServicesMinimumTlsVersion : IEquatable<MediaServicesMinimumTlsVersion>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MediaServicesMinimumTlsVersion"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MediaServicesMinimumTlsVersion(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string Tls10Value = "Tls10";
        private const string Tls11Value = "Tls11";
        private const string Tls12Value = "Tls12";
        private const string Tls13Value = "Tls13";

        /// <summary> Minimum TLS version is TLS 1.0. </summary>
        public static MediaServicesMinimumTlsVersion Tls10 { get; } = new MediaServicesMinimumTlsVersion(Tls10Value);
        /// <summary> Minimum TLS version is TLS 1.1. </summary>
        public static MediaServicesMinimumTlsVersion Tls11 { get; } = new MediaServicesMinimumTlsVersion(Tls11Value);
        /// <summary> Minimum TLS version is TLS 1.2. </summary>
        public static MediaServicesMinimumTlsVersion Tls12 { get; } = new MediaServicesMinimumTlsVersion(Tls12Value);
        /// <summary> Minimum TLS version is TLS 1.3. </summary>
        public static MediaServicesMinimumTlsVersion Tls13 { get; } = new MediaServicesMinimumTlsVersion(Tls13Value);
        /// <summary> Determines if two <see cref="MediaServicesMinimumTlsVersion"/> values are the same. </summary>
        public static bool operator ==(MediaServicesMinimumTlsVersion left, MediaServicesMinimumTlsVersion right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MediaServicesMinimumTlsVersion"/> values are not the same. </summary>
        public static bool operator !=(MediaServicesMinimumTlsVersion left, MediaServicesMinimumTlsVersion right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MediaServicesMinimumTlsVersion"/>. </summary>
        public static implicit operator MediaServicesMinimumTlsVersion(string value) => new MediaServicesMinimumTlsVersion(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MediaServicesMinimumTlsVersion other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MediaServicesMinimumTlsVersion other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
