// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> The current provisioning state. </summary>
    public readonly partial struct MediaPrivateEndpointConnectionProvisioningState : IEquatable<MediaPrivateEndpointConnectionProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MediaPrivateEndpointConnectionProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MediaPrivateEndpointConnectionProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string CreatingValue = "Creating";
        private const string DeletingValue = "Deleting";
        private const string FailedValue = "Failed";

        /// <summary> Succeeded. </summary>
        public static MediaPrivateEndpointConnectionProvisioningState Succeeded { get; } = new MediaPrivateEndpointConnectionProvisioningState(SucceededValue);
        /// <summary> Creating. </summary>
        public static MediaPrivateEndpointConnectionProvisioningState Creating { get; } = new MediaPrivateEndpointConnectionProvisioningState(CreatingValue);
        /// <summary> Deleting. </summary>
        public static MediaPrivateEndpointConnectionProvisioningState Deleting { get; } = new MediaPrivateEndpointConnectionProvisioningState(DeletingValue);
        /// <summary> Failed. </summary>
        public static MediaPrivateEndpointConnectionProvisioningState Failed { get; } = new MediaPrivateEndpointConnectionProvisioningState(FailedValue);
        /// <summary> Determines if two <see cref="MediaPrivateEndpointConnectionProvisioningState"/> values are the same. </summary>
        public static bool operator ==(MediaPrivateEndpointConnectionProvisioningState left, MediaPrivateEndpointConnectionProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MediaPrivateEndpointConnectionProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(MediaPrivateEndpointConnectionProvisioningState left, MediaPrivateEndpointConnectionProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MediaPrivateEndpointConnectionProvisioningState"/>. </summary>
        public static implicit operator MediaPrivateEndpointConnectionProvisioningState(string value) => new MediaPrivateEndpointConnectionProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MediaPrivateEndpointConnectionProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MediaPrivateEndpointConnectionProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
