// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> Describes a list of inputs to a Job. </summary>
    public partial class MediaJobInputs : MediaJobInputBasicProperties
    {
        /// <summary> Initializes a new instance of <see cref="MediaJobInputs"/>. </summary>
        public MediaJobInputs()
        {
            Inputs = new ChangeTrackingList<MediaJobInputBasicProperties>();
            OdataType = "#Microsoft.Media.JobInputs";
        }

        /// <summary> Initializes a new instance of <see cref="MediaJobInputs"/>. </summary>
        /// <param name="odataType"> The discriminator for derived types. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="inputs">
        /// List of inputs to a Job.
        /// Please note <see cref="MediaJobInputBasicProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MediaJobInputAsset"/>, <see cref="MediaJobInputClip"/>, <see cref="MediaJobInputHttp"/>, <see cref="MediaJobInputs"/> and <see cref="MediaJobInputSequence"/>.
        /// </param>
        internal MediaJobInputs(string odataType, IDictionary<string, BinaryData> serializedAdditionalRawData, IList<MediaJobInputBasicProperties> inputs) : base(odataType, serializedAdditionalRawData)
        {
            Inputs = inputs;
            OdataType = odataType ?? "#Microsoft.Media.JobInputs";
        }

        /// <summary>
        /// List of inputs to a Job.
        /// Please note <see cref="MediaJobInputBasicProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MediaJobInputAsset"/>, <see cref="MediaJobInputClip"/>, <see cref="MediaJobInputHttp"/>, <see cref="MediaJobInputs"/> and <see cref="MediaJobInputSequence"/>.
        /// </summary>
        public IList<MediaJobInputBasicProperties> Inputs { get; }
    }
}
