// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> The Asset File Storage encryption metadata. </summary>
    public partial class MediaAssetFileEncryptionMetadata
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MediaAssetFileEncryptionMetadata"/>. </summary>
        /// <param name="assetFileId"> The Asset File Id. </param>
        internal MediaAssetFileEncryptionMetadata(Guid assetFileId)
        {
            AssetFileId = assetFileId;
        }

        /// <summary> Initializes a new instance of <see cref="MediaAssetFileEncryptionMetadata"/>. </summary>
        /// <param name="initializationVector"> The Asset File initialization vector. </param>
        /// <param name="assetFileName"> The Asset File name. </param>
        /// <param name="assetFileId"> The Asset File Id. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MediaAssetFileEncryptionMetadata(string initializationVector, string assetFileName, Guid assetFileId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            InitializationVector = initializationVector;
            AssetFileName = assetFileName;
            AssetFileId = assetFileId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MediaAssetFileEncryptionMetadata"/> for deserialization. </summary>
        internal MediaAssetFileEncryptionMetadata()
        {
        }

        /// <summary> The Asset File initialization vector. </summary>
        public string InitializationVector { get; }
        /// <summary> The Asset File name. </summary>
        public string AssetFileName { get; }
        /// <summary> The Asset File Id. </summary>
        public Guid AssetFileId { get; }
    }
}
