// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> The permissions to set on the SAS URL. </summary>
    public readonly partial struct MediaAssetContainerPermission : IEquatable<MediaAssetContainerPermission>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MediaAssetContainerPermission"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MediaAssetContainerPermission(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ReadValue = "Read";
        private const string ReadWriteValue = "ReadWrite";
        private const string ReadWriteDeleteValue = "ReadWriteDelete";

        /// <summary> The SAS URL will allow read access to the container. </summary>
        public static MediaAssetContainerPermission Read { get; } = new MediaAssetContainerPermission(ReadValue);
        /// <summary> The SAS URL will allow read and write access to the container. </summary>
        public static MediaAssetContainerPermission ReadWrite { get; } = new MediaAssetContainerPermission(ReadWriteValue);
        /// <summary> The SAS URL will allow read, write and delete access to the container. </summary>
        public static MediaAssetContainerPermission ReadWriteDelete { get; } = new MediaAssetContainerPermission(ReadWriteDeleteValue);
        /// <summary> Determines if two <see cref="MediaAssetContainerPermission"/> values are the same. </summary>
        public static bool operator ==(MediaAssetContainerPermission left, MediaAssetContainerPermission right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MediaAssetContainerPermission"/> values are not the same. </summary>
        public static bool operator !=(MediaAssetContainerPermission left, MediaAssetContainerPermission right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MediaAssetContainerPermission"/>. </summary>
        public static implicit operator MediaAssetContainerPermission(string value) => new MediaAssetContainerPermission(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MediaAssetContainerPermission other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MediaAssetContainerPermission other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
