// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> The resource state of the live output. </summary>
    public readonly partial struct LiveOutputResourceState : IEquatable<LiveOutputResourceState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LiveOutputResourceState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LiveOutputResourceState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string RunningValue = "Running";
        private const string DeletingValue = "Deleting";

        /// <summary> Live output is being created. No content is archived in the asset until the live output is in running state. </summary>
        public static LiveOutputResourceState Creating { get; } = new LiveOutputResourceState(CreatingValue);
        /// <summary> Live output is running and archiving live streaming content to the asset if there is valid input from a contribution encoder. </summary>
        public static LiveOutputResourceState Running { get; } = new LiveOutputResourceState(RunningValue);
        /// <summary> Live output is being deleted. The live asset is being converted from live to on-demand asset. Any streaming URLs created on the live output asset continue to work. </summary>
        public static LiveOutputResourceState Deleting { get; } = new LiveOutputResourceState(DeletingValue);
        /// <summary> Determines if two <see cref="LiveOutputResourceState"/> values are the same. </summary>
        public static bool operator ==(LiveOutputResourceState left, LiveOutputResourceState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LiveOutputResourceState"/> values are not the same. </summary>
        public static bool operator !=(LiveOutputResourceState left, LiveOutputResourceState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LiveOutputResourceState"/>. </summary>
        public static implicit operator LiveOutputResourceState(string value) => new LiveOutputResourceState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LiveOutputResourceState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LiveOutputResourceState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
