// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> The resource state of the live event. See https://go.microsoft.com/fwlink/?linkid=2139012 for more information. </summary>
    public readonly partial struct LiveEventResourceState : IEquatable<LiveEventResourceState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LiveEventResourceState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LiveEventResourceState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StoppedValue = "Stopped";
        private const string AllocatingValue = "Allocating";
        private const string StandByValue = "StandBy";
        private const string StartingValue = "Starting";
        private const string RunningValue = "Running";
        private const string StoppingValue = "Stopping";
        private const string DeletingValue = "Deleting";

        /// <summary> This is the initial state of the live event after creation (unless autostart was set to true.) No billing occurs in this state. In this state, the live event properties can be updated but streaming is not allowed. </summary>
        public static LiveEventResourceState Stopped { get; } = new LiveEventResourceState(StoppedValue);
        /// <summary> Allocate action was called on the live event and resources are being provisioned for this live event. Once allocation completes successfully, the live event will transition to StandBy state. </summary>
        public static LiveEventResourceState Allocating { get; } = new LiveEventResourceState(AllocatingValue);
        /// <summary> Live event resources have been provisioned and is ready to start. Billing occurs in this state. Most properties can still be updated, however ingest or streaming is not allowed during this state. </summary>
        public static LiveEventResourceState StandBy { get; } = new LiveEventResourceState(StandByValue);
        /// <summary> The live event is being started and resources are being allocated. No billing occurs in this state. Updates or streaming are not allowed during this state. If an error occurs, the live event returns to the Stopped state. </summary>
        public static LiveEventResourceState Starting { get; } = new LiveEventResourceState(StartingValue);
        /// <summary> The live event resources have been allocated, ingest and preview URLs have been generated, and it is capable of receiving live streams. At this point, billing is active. You must explicitly call Stop on the live event resource to halt further billing. </summary>
        public static LiveEventResourceState Running { get; } = new LiveEventResourceState(RunningValue);
        /// <summary> The live event is being stopped and resources are being de-provisioned. No billing occurs in this transient state. Updates or streaming are not allowed during this state. </summary>
        public static LiveEventResourceState Stopping { get; } = new LiveEventResourceState(StoppingValue);
        /// <summary> The live event is being deleted. No billing occurs in this transient state. Updates or streaming are not allowed during this state. </summary>
        public static LiveEventResourceState Deleting { get; } = new LiveEventResourceState(DeletingValue);
        /// <summary> Determines if two <see cref="LiveEventResourceState"/> values are the same. </summary>
        public static bool operator ==(LiveEventResourceState left, LiveEventResourceState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LiveEventResourceState"/> values are not the same. </summary>
        public static bool operator !=(LiveEventResourceState left, LiveEventResourceState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LiveEventResourceState"/>. </summary>
        public static implicit operator LiveEventResourceState(string value) => new LiveEventResourceState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LiveEventResourceState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LiveEventResourceState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
