// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> Live event preview settings. </summary>
    public partial class LiveEventPreview
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LiveEventPreview"/>. </summary>
        public LiveEventPreview()
        {
            Endpoints = new ChangeTrackingList<LiveEventEndpoint>();
        }

        /// <summary> Initializes a new instance of <see cref="LiveEventPreview"/>. </summary>
        /// <param name="endpoints"> The endpoints for preview. Do not share the preview URL with the live event audience. </param>
        /// <param name="accessControl"> The access control for live event preview. </param>
        /// <param name="previewLocator"> The identifier of the preview locator in Guid format. Specifying this at creation time allows the caller to know the preview locator url before the event is created. If omitted, the service will generate a random identifier. This value cannot be updated once the live event is created. </param>
        /// <param name="streamingPolicyName"> The name of streaming policy used for the live event preview. This value is specified at creation time and cannot be updated. </param>
        /// <param name="alternativeMediaId"> An alternative media identifier associated with the streaming locator created for the preview. This value is specified at creation time and cannot be updated. The identifier can be used in the CustomLicenseAcquisitionUrlTemplate or the CustomKeyAcquisitionUrlTemplate of the StreamingPolicy specified in the StreamingPolicyName field. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LiveEventPreview(IList<LiveEventEndpoint> endpoints, LiveEventPreviewAccessControl accessControl, string previewLocator, string streamingPolicyName, string alternativeMediaId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Endpoints = endpoints;
            AccessControl = accessControl;
            PreviewLocator = previewLocator;
            StreamingPolicyName = streamingPolicyName;
            AlternativeMediaId = alternativeMediaId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The endpoints for preview. Do not share the preview URL with the live event audience. </summary>
        public IList<LiveEventEndpoint> Endpoints { get; }
        /// <summary> The access control for live event preview. </summary>
        internal LiveEventPreviewAccessControl AccessControl { get; set; }
        /// <summary> The IP allow list. </summary>
        public IList<IPRange> IPAllowedIPs
        {
            get
            {
                if (AccessControl is null)
                    AccessControl = new LiveEventPreviewAccessControl();
                return AccessControl.IPAllowedIPs;
            }
        }

        /// <summary> The identifier of the preview locator in Guid format. Specifying this at creation time allows the caller to know the preview locator url before the event is created. If omitted, the service will generate a random identifier. This value cannot be updated once the live event is created. </summary>
        public string PreviewLocator { get; set; }
        /// <summary> The name of streaming policy used for the live event preview. This value is specified at creation time and cannot be updated. </summary>
        public string StreamingPolicyName { get; set; }
        /// <summary> An alternative media identifier associated with the streaming locator created for the preview. This value is specified at creation time and cannot be updated. The identifier can be used in the CustomLicenseAcquisitionUrlTemplate or the CustomKeyAcquisitionUrlTemplate of the StreamingPolicy specified in the StreamingPolicyName field. </summary>
        public string AlternativeMediaId { get; set; }
    }
}
