// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> Live event type. When encodingType is set to PassthroughBasic or PassthroughStandard, the service simply passes through the incoming video and audio layer(s) to the output. When encodingType is set to Standard or Premium1080p, a live encoder transcodes the incoming stream into multiple bitrates or layers. See https://go.microsoft.com/fwlink/?linkid=2095101 for more information. This property cannot be modified after the live event is created. </summary>
    public readonly partial struct LiveEventEncodingType : IEquatable<LiveEventEncodingType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LiveEventEncodingType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LiveEventEncodingType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string StandardValue = "Standard";
        private const string Premium1080PValue = "Premium1080p";
        private const string PassthroughBasicValue = "PassthroughBasic";
        private const string PassthroughStandardValue = "PassthroughStandard";

        /// <summary> This is the same as PassthroughStandard, please see description below. This enumeration value is being deprecated. </summary>
        public static LiveEventEncodingType None { get; } = new LiveEventEncodingType(NoneValue);
        /// <summary> A contribution live encoder sends a single bitrate stream to the live event and Media Services creates multiple bitrate streams. The output cannot exceed 720p in resolution. </summary>
        public static LiveEventEncodingType Standard { get; } = new LiveEventEncodingType(StandardValue);
        /// <summary> A contribution live encoder sends a single bitrate stream to the live event and Media Services creates multiple bitrate streams. The output cannot exceed 1080p in resolution. </summary>
        public static LiveEventEncodingType Premium1080P { get; } = new LiveEventEncodingType(Premium1080PValue);
        /// <summary> The ingested stream passes through the live event from the contribution encoder without any further processing. In the PassthroughBasic mode, ingestion is limited to up to 5Mbps and only 1 concurrent live output is allowed. Live transcription is not available. </summary>
        public static LiveEventEncodingType PassthroughBasic { get; } = new LiveEventEncodingType(PassthroughBasicValue);
        /// <summary> The ingested stream passes through the live event from the contribution encoder without any further processing. Live transcription is available. Ingestion bitrate limits are much higher and up to 3 concurrent live outputs are allowed. </summary>
        public static LiveEventEncodingType PassthroughStandard { get; } = new LiveEventEncodingType(PassthroughStandardValue);
        /// <summary> Determines if two <see cref="LiveEventEncodingType"/> values are the same. </summary>
        public static bool operator ==(LiveEventEncodingType left, LiveEventEncodingType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LiveEventEncodingType"/> values are not the same. </summary>
        public static bool operator !=(LiveEventEncodingType left, LiveEventEncodingType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LiveEventEncodingType"/>. </summary>
        public static implicit operator LiveEventEncodingType(string value) => new LiveEventEncodingType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LiveEventEncodingType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LiveEventEncodingType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
