// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Media.Models
{
    public partial class LiveEventEncoding : IUtf8JsonSerializable, IJsonModel<LiveEventEncoding>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<LiveEventEncoding>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<LiveEventEncoding>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LiveEventEncoding>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(LiveEventEncoding)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(EncodingType))
            {
                writer.WritePropertyName("encodingType"u8);
                writer.WriteStringValue(EncodingType.Value.ToString());
            }
            if (Optional.IsDefined(PresetName))
            {
                writer.WritePropertyName("presetName"u8);
                writer.WriteStringValue(PresetName);
            }
            if (Optional.IsDefined(StretchMode))
            {
                if (StretchMode != null)
                {
                    writer.WritePropertyName("stretchMode"u8);
                    writer.WriteStringValue(StretchMode.Value.ToString());
                }
                else
                {
                    writer.WriteNull("stretchMode");
                }
            }
            if (Optional.IsDefined(KeyFrameInterval))
            {
                if (KeyFrameInterval != null)
                {
                    writer.WritePropertyName("keyFrameInterval"u8);
                    writer.WriteStringValue(KeyFrameInterval.Value, "P");
                }
                else
                {
                    writer.WriteNull("keyFrameInterval");
                }
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        LiveEventEncoding IJsonModel<LiveEventEncoding>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LiveEventEncoding>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(LiveEventEncoding)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeLiveEventEncoding(document.RootElement, options);
        }

        internal static LiveEventEncoding DeserializeLiveEventEncoding(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            LiveEventEncodingType? encodingType = default;
            string presetName = default;
            InputVideoStretchMode? stretchMode = default;
            TimeSpan? keyFrameInterval = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("encodingType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    encodingType = new LiveEventEncodingType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("presetName"u8))
                {
                    presetName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("stretchMode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        stretchMode = null;
                        continue;
                    }
                    stretchMode = new InputVideoStretchMode(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("keyFrameInterval"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        keyFrameInterval = null;
                        continue;
                    }
                    keyFrameInterval = property.Value.GetTimeSpan("P");
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new LiveEventEncoding(encodingType, presetName, stretchMode, keyFrameInterval, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<LiveEventEncoding>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LiveEventEncoding>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(LiveEventEncoding)} does not support writing '{options.Format}' format.");
            }
        }

        LiveEventEncoding IPersistableModel<LiveEventEncoding>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LiveEventEncoding>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeLiveEventEncoding(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(LiveEventEncoding)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<LiveEventEncoding>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
