// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> The KeyVaultProperties. </summary>
    public partial class KeyVaultProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="KeyVaultProperties"/>. </summary>
        public KeyVaultProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="KeyVaultProperties"/>. </summary>
        /// <param name="keyIdentifier"> The URL of the Key Vault key used to encrypt the account. The key may either be versioned (for example https://vault/keys/mykey/version1) or reference a key without a version (for example https://vault/keys/mykey). </param>
        /// <param name="currentKeyIdentifier"> The current key used to encrypt the Media Services account, including the key version. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal KeyVaultProperties(string keyIdentifier, string currentKeyIdentifier, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            KeyIdentifier = keyIdentifier;
            CurrentKeyIdentifier = currentKeyIdentifier;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The URL of the Key Vault key used to encrypt the account. The key may either be versioned (for example https://vault/keys/mykey/version1) or reference a key without a version (for example https://vault/keys/mykey). </summary>
        public string KeyIdentifier { get; set; }
        /// <summary> The current key used to encrypt the Media Services account, including the key version. </summary>
        public string CurrentKeyIdentifier { get; }
    }
}
